<?php

use Mtc\Shop\Warning;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Manage Warnings';

$errors = [];

if ($_REQUEST['action'] === 'delete' && is_numeric($_REQUEST['delete_id'])) {
    $warning = (new Warning)->find($_REQUEST['delete_id']);
    // Delete the items
    $warning->items()->detach();
    // Delete the site
    $warning->delete();
    header('location: manage.warnings.php');
    exit;
}

$warnings = Warning::query()->orderBy('warning_type')->get();

require_once $path . 'core/admin/templates/adminheader.html.php';

?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>

    <li class="end">Warnings</li>
</ul>

<h1>Warnings</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) { showerrors($errors); }

if (count($warnings) > 0) {
    ?>
    <form method="post">
        <table class="manage-items">
            <tr>
                <th nowrap="">Warning Type</th>
                <th>Message</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular">
            <?php
            foreach ($warnings as $warning) {
                ?>
                <tr id="rorder-<?= $warning->id;?>">
                    <td><?= Warning::$warning_types[$warning->warning_type]; ?></td>
                    <td><?= clean_page($warning->content); ?></td>
                    <td class="center"><a href="manage.warning.php?id=<?=$warning->id; ?>" class="edit" ><i class="fa fa-pencil"></i></a></td>
                    <td class="center"><a href="manage.warnings.php?action=delete&delete_id=<?=$warning->id; ?>" class="alert picto error" title="Are you sure you want to delete the Warning?"><i class="fa fa-times-circle"></i></a></td>
                </tr>
                <?php
            }
            ?>
            </tbody>
        </table>
        <input type="hidden" name="action" value="update">
    </form>
    <?php
} else {
    ?>
    <p>No Warnings have been created</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
