<?php
/**
 * Custom Field Set Eloquent model
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * Custom Field Set Eloquent model.
 * Implements Shop Custom Field Set management
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomFieldSet extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'custom_fields_sets';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'default'
    ];

    /**
     * Define relationship with fields assigned to this Set
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function fields()
    {
        return $this->hasMany(CustomFieldSetField::class, 'set_id');
    }


    public static function getDefault() : CustomFieldSet
    {
        $default_set = self::query()
            ->where('default', 1)
            ->first()
        ;

        return $default_set;
    }
}
