<?php

namespace Mtc\Shop\Events;

use Illuminate\Database\Eloquent\Model;

/**
 * Model Form Footer event, triggered at the bottom of admin page, within the
 * form.
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ModelFormFooter
{
    /**
     * The Eloquent model that is currently being loaded.
     *
     * @var null|Model
     */
    public $model = null;

    /**
     * Initiate the event, storing the provided model.
     *
     * @param Model $model Eloquent model instance
     */
    public function __construct(Model $model)
    {
        $this->model = $model;
    }
}
