<?php

namespace Mtc\Shop\Order;

use App\Casts\OptionalEncrypted;
use App\Src\Encryption;
use Mtc\Core\Address as CoreAddress;

/**
 * Generic Address Eloquent Model.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 20.10.2016.
 */
class Address extends CoreAddress
{
    // Use Belongs to Order Trait
    use BelongsToOrder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'order_address';

    protected $fillable = [
        'order_id',
        'type',
        'gender',
        'title',
        'firstname',
        'middle_name',
        'lastname',
        'address1',
        'address2',
        'city',
        'state',
        'country',
        'postcode',
        'notes',
    ];

    protected $casts = [
        'firstname' => OptionalEncrypted::class,
        'middle_name' => OptionalEncrypted::class,
        'lastname' => OptionalEncrypted::class,
        'address1' => OptionalEncrypted::class,
        'address2' => OptionalEncrypted::class,
        'city' => OptionalEncrypted::class,
        'postcode' => OptionalEncrypted::class,
    ];

    public static $searchable = [
        'firstname',
        'lastname',
        'postcode',
    ];

    /**
     * Boots the model and sets up event listeners or other necessary configurations.
     *
     * @return void
     */
    protected static function boot() : void
    {
        parent::boot();

        self::saved(function (self $model) {
            Encryption::updateHashes($model);
        });
    }

}