<?php
/**
 * The controller for Search template.
 * @description Retrieves a list of search results by a query defined as a GET['filter'] parameter.
 * @author Haroldas Latonas <haroldas.latonas@mtcmedia.co.uk>
 * @version 1 09/12/2016 * Time: 10:00
 */

$search_term = "";
if (isset($_GET['search_filter'])) {
    $search_term = $_GET['search_filter'];
}

$search_lister = Search::newInstance()
    ->setLimit(10)                      // set number of articles (pages) per one pagination page
    ->setSearchTerm($search_term)
    ->setCurrentPage($_GET['page'])     // pass page number (its safe to pass unset vars)
    ->run();                            // before getting anything - one needs to "run()" this whole setup

$search_lister->getListing();            // get listing
$search_lister->getPagination($twig);    // get pagination

$twig->addGlobal('search_term', $search_term);
$twig->addGlobal('search_results', $search_lister->list);
$twig->addGlobal('search_pagination', $search_lister->pagination);
