<?php

use Mtc\Core\AdminMenu;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'grant_access' => null,
]);

$page_meta['title'] = 'Edit Menu';

//initialize variables
if (!isset($_REQUEST['id'])) {
    $_REQUEST['id'] = null;
}

if (!isset($_REQUEST['action'])) {
    $_REQUEST['action'] = null;
}

$errors = null;

$added = !empty($_REQUEST['added']) ? $_REQUEST['added'] : '';

if (isset($_REQUEST['id']) && $_REQUEST['id'] > 0) {
    $addedit = 'Update';
} else {
    $addedit = 'Add';
}

$pagename = 'Admin Menu';
$table = 'admin_menu';

$page_meta['title'] = $addedit .' '. $pagename;

$display_form = true;

$nav = AdminMenu::query()
    ->find($_REQUEST['id'])
    ->toArray();

//add

if (!empty($_REQUEST['action']) && $_REQUEST['action'] == 'update') {
    // do add/edit
    // set data
    $nav['title'] = $_REQUEST['title'];
    $nav['sub_id'] = $_REQUEST['sub_id'];
    $nav['path'] = $_REQUEST['path'];
    $nav['activePath'] = $_REQUEST['activePath'];
    $nav['constant'] = $_REQUEST['constant'];
    $nav['icon'] = $_REQUEST['icon'];
    $nav['new_window'] = 0;

    if (isset($_REQUEST['new_window'])) {
        $nav['new_window'] = 1;
    }

    // error reporting
    if (empty($nav['title'])) {
        $errors[]='You must enter a title';
    }

    if (empty($nav['path']) && $_REQUEST['sub_id'] > 0) {
        $errors[]='You must enter a URL';
    }

    // if no errors do the update / insert
    if (empty($errors)) {
        $params = [
            ':title' => $nav['title'],
            ':sub_id' => $nav['sub_id'],
            ':path' => $nav['path'],
            ':activePath' => $nav['activePath'],
            ':constant' => $nav['constant'],
            ':icon' => $nav['icon'],
            ':new_window' => $nav['new_window']
        ];

        if (!empty($_REQUEST['id'])) {
            AdminMenu::query()
                ->where('id', '=', $_REQUEST['id'])
                ->update($nav);

        } else {

            $newMenu = AdminMenu::query()
                ->create($nav);

            $added_menu_item_id = $newMenu->id;

            //go to edit page and pass id and status
            header('Location: /admin/adminmenu/edit.menu.php?id=' . $added_menu_item_id . '&added=true');
            exit();
        }

        $updated = true;
    }
}

require_once $path .'core/admin/templates/adminheader.html.php';

?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="/admin/adminmenu/menu.php">Manage Admin Menu</a> /</li>
        <li class="end"><?= clean_page($addedit) . " " . clean_page($pagename) ?></li>
    </ul>

    <h1><?=$addedit?> <?=$pagename?></h1>

<?php

include 'tabnav.menu.php';

if (!empty($updated)) {
    if (empty($errors) && isset($_REQUEST['action'])) {
        echo showmsg($pagename . " updated", "success", $path);
    }
}

if (!empty($added) && !isset($updated)) {
    if (empty($errors)) {
        echo showmsg($pagename . " added", "success", $path);
    }
}

    if (!empty($errors)) {
        showerrors($errors);
    }

    if ($display_form) {
        ?>
        <form action="" method="POST" enctype="multipart/form-data" class="style">
        <fieldset class="show">
            <h1><a class="show el">Information <i class="fa fa-caret-right"></i></a></h1>

            <div class="row">
                <label for="title">Title</label>
                <input type="text" name="title" id="title" value="<?= clean_page($nav['title'] ?? null) ?>" class="INPUT1">
            </div>

            <div class="row">
                <label for="title">Parent</label>
                <select name="sub_id">
                    <option value="0">Root</option>
                    <?php
                        $selected = $nav['sub_id'] ?? null;
                        $this_id = empty($_REQUEST['id']) ?
                            0 :
                            $_REQUEST['id'];
                        $menus = AdminMenu::query()
                            ->where('id', '<>', $this_id)
                            ->where('sub_id', '=', 0)
                            ->orderBy('order')
                            ->orderBy('title')
                            ->get();
                        foreach ($menus as $menu) {
                            $cdata = $menu->toArray();
                            $extra = '';
                            ?>
                            <option value="<?=$cdata['id']?>"<?= ($selected == $cdata['id']) ? " selected" : '' ?>>
                                <?= clean_page($extra) ?><?= clean_page($cdata['title']) ?>
                            </option>
                            <?php
                        }
                    ?>
                </select>
            </div>

            <div class="row">
                <label for="path">Page URL</label>
                <input type="text" name="path" id="path" value="<?= clean_page($nav['path'] ?? null) ?>" class="INPUT1">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div class="text">
                        <h1>URL</h1>
                        <p>Link to the page. No need to include the site url, instead use something like /admin/path-to-page.php</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <label for="activePath">Active Path</label>
                <input type="text" name="activePath" id="activePath" value="<?= clean_page($nav['activePath'] ?? null);?>" class="INPUT1">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div class="text">
                        <h1>Active Path</h1>
                        <p>This is a path that if it is part of the URL the class of &quot;active&quot; will be applied to the menu item.</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <label for="constant">Settings Constant</label>
                <input type="text" name="constant" id="constant" value="<?= clean_page($nav['constant'] ?? null) ?>" class="INPUT1">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div class="text">
                        <h1>Constant</h1>
                        <p>This should be the defined constant from the settings file to turn this feature on. Can be blank if it is not required.</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <label for="icon">Icon</label>
                <input type="text" name="icon" id="icon" value="<?= clean_page($nav['icon'] ?? null) ?>" class="INPUT1">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div class="text">
                        <h1>Icon</h1>
                        <p>Class for the icon you want to show up - see /admin/css/font-awesome/font-awesome.css for list of icons</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <label for="new_window">Open in a new window?</label>
                <input type="checkbox"
                        name="new_window" id="new_window"<?= (isset($nav['new_window']) && $nav['new_window'] == 1) ? ' checked' : '' ?> class="INPUT1">
            </div>

	    <?php
	    if (empty($_REQUEST['id'])) {
	    ?>
		    <div class="row">
		        <label for="grant_access">Grant access to all admin users?</label>
		        <input type="hidden" name="grant_access" value="0">
		        <input type="checkbox" name="grant_access" id="grant_access" value="1" class="INPUT1">
		    </div>
	    <?php
		}
		?>
        </fieldset>

            <input type="hidden" name="action" value="update"/>
            <input type="hidden" name="id" value="<?= clean_page($_REQUEST['id']) ?>"/>

            <div class="row"><input type="submit" value="Save"/></div>

        </form>

        <?php
    }

require_once $path . 'core/admin/templates/adminfooter.html.php';
