<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Mtc\Modules\Members\Models\Member;
use Mtc\Modules\Members\Models\MembersAddress;

class MembersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('members_addresses')->delete();
        \DB::table('members')->delete();

        Member::factory()
            ->count(10)
            ->has(MembersAddress::factory()->billing()->count(1),  'addressBilling')
            ->has(MembersAddress::factory()->shipping()->count(1),  'addressShipping')
            ->create();
    }
}
