<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Mtc\Shop\Order;

class OrderStripeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('order_stripe')->delete();

        $orders = Order::all();

        foreach ($orders as $order) {
            DB::table('order_stripe')->insert([
                'order_id' => $order->id,
                'charge_id' => Str::random(24),
                'order_ref' => Str::random(24),
                'timestamp' => now(),
                'amount' => $order->cost_total
            ]);
        }
    }
}
