<?php
/**
 * Main form edit template
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
$show_all = '';
if (! isset($form) || ! $form->id) {
    $show_all = 'show';
}
$form_id = '';
if (!empty($_REQUEST['id'])) {
    $form_id = $_REQUEST['id'];
}
?>
<div>
    <div id="message"
         class="el msg">
    </div>
    <form action="<?= $_SERVER['PHP_SELF'] ?>?id=<?= $form_id ?>" method="post" class="style">
        <fieldset class="show" id="info">
            <h1>
                <a class="show el"
                   @click="toggleShowInfo">
                    Form Info
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>
            <div v-show="show_info">
                <div class="row">
                    <label for="name">
                        Name
                    </label>
                    <input type="text"
                           name="name"
                           id="name"
                           v-model="form.name" />
                </div>
                <div class="row">
                    <label for="published">
                        Published?
                    </label>
                    <input type="checkbox"
                           name="published"
                           id="published"
                           v-bind:true-value="1"
                           v-model="form.published"/>
                </div>
                <div class="row">
                    <label for="display_until">
                        Published until
                    </label>
                    <input type="checkbox"
                           name="no_limit"
                           v-bind:true-value="1"
                           v-model="form.no_limit"
                           id="no_limit"/>
                    <label for="no_limit"
                           class="inline">
                        Indefinitely
                        <span v-show="form.no_limit == 0">
                             OR until
                        </span>
                    </label>
                    <input type="text"
                           v-show="form.no_limit == 0"
                           name="display_until"
                           id="display_until"
                           class="inline datetime"
                           v-date-time-picker
                           v-model="form.display_until" />
                </div>
                <div class="row">
                    <label for="info_text">
                        Info Text
                    </label>
                    <textarea name="info_text"
                              id="info_text"
                              v-tinymce="form.info_text"
                              v-model="form.info_text"></textarea>
                </div>
                <div class="row">
                    <label for="success_text">
                        Success Text
                    </label>
                    <textarea name="success_text"
                              id="success_text"
                              v-tinymce="form.success_text"
                              v-model="form.success_text"></textarea>
                </div>
                <div class="row">
                    <label for="css_class">
                        Form CSS class
                    </label>
                    <input type="text"
                           name="css_class"
                           id="css_class"
                           v-model="form.css_class" />
                </div>
                <div class="row">
                    <label for="css_id">
                        Form CSS id
                    </label>
                    <input type="text"
                           name="css_id"
                           id="css_id"
                           v-model="form.css_id" />
                </div>
                <div class="row">
                    <label for="button_class">
                        Button CSS class
                    </label>
                    <input type="text"
                           name="button_class"
                           id="button_class"
                           v-model="form.button_class" />
                </div>
                <div class="row">
                    <label for="submit_text">
                        Submit button text
                    </label>
                    <input type="text"
                           name="submit_text"
                           id="submit_text"
                           v-model="form.submit_text" />
                </div>
            </div>
        </fieldset>
        <fieldset class="show" id="settings">
            <h1>
                <a class="show el"
                   @click="toggleShowSettings()">
                    Form settings
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>

            <div v-show="show_settings">
                <div class="row">
                    <label for="save_db">
                        Save responses in database?
                    </label>
                    <input type="checkbox"
                           name="save_db"
                           value="1"
                           v-bind:true-value="1"
                           v-model="form.save_db"
                           id="save_db" />
                </div>

                <div class="row">
                    <label for="send_email">Send out email</label>
                    <input type="checkbox"
                           name="send_email"
                           id="send_email"
                           v-model="form.send_email"
                           v-bind:true-value="1"
                           value="1"/>

                    <label for="email_receiver"
                           class="inline">
                        email to be sent to
                    </label>
                    <input type="text"
                           name="email_receiver"
                           id="email_receiver"
                           v-model="form.email_receiver" />
                </div>

                <div class="row">
                    <label for="type">
                        Callback
                    </label>

                    <input type="radio"
                           name="callback"
                           id="no_callback"
                           v-model="form.callback"
                           v-bind:true-value="0"
                           value="0"/>
                    <label for="no_callback"
                           class="inline">
                        No Callback
                    </label>

                    <input type="radio" name="callback"
                           id="callback_class"
                           v-model="form.callback"
                           v-bind:true-value="1"
                           value="1"/>
                    <label for="callback_class" class="inline">
                        Callback to Class function
                    </label>
                </div>

                <div class="row">
                    <label for="callback_class_value">
                        Callback Class
                    </label>
                    <input type="text"
                           name="callback_class"
                           id="callback_class_value"
                           v-model="form.callback_class" />
                </div>

                <div class="row">
                    <label for="callback_function_value">
                        Callback Function
                    </label>
                    <input type="text"
                           name="callback_action"
                           id="callback_function_value"
                           v-model="form.callback_action" />
                </div>

                <div class="row">
                    <label for="redirect">
                        Redirect after success
                    </label>
                    <input type="text"
                           name="redirect"
                           id="redirect"
                           v-model="form.redirect" />
                </div>
            </div>
        </fieldset>
        <fieldset class="show questionFieldset" id="questions">
            <h1>
                <a class="show el"
                   @click="toggleShowQuestions()">
                    Form Elements
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>
            <div id="formQuestions"
                 v-show="show_questions">
                <?php
                require 'templates/question.list.php';
                ?>
            </div>
        </fieldset>
        <fieldset class="show fieldsetFieldset" id="fieldsets">
            <h1>
                <a class="show el"
                   @click="toggleShowFieldsets()">
                    Form Fieldsets
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>
            <div id="formFieldset"
                 v-show="show_fieldsets">
                <?php
                require 'templates/fieldset.list.php';
                ?>
            </div>
        </fieldset>
        <fieldset class="show organizeFieldset">
            <h1>
                <a class="show el"
                   @click="toggleShowOrdering()">
                    Change Ordering
                    <i class="fa fa-caret-right"></i>
                </a>
            </h1>
            <div id="formOrdering"
                 v-show="show_ordering">
                <?php
                require 'templates/ordering.php';
                ?>
            </div>
        </fieldset>
        <div class="row">
            <input type="hidden" name="action" value="update"/>
            <input type="hidden"
                   name="id"
                   id="form_id"
                   v-model="form_id"
                   :value="form.id"/>
            <input type="submit"
                   @click.prevent="saveForm()"
                   id="save"
                   value="Save"/>
            <a @click="doPreview()"
               class="btn actionButton secondaryActionButton"
               v-show="show_preview"
               target="_blank">
                Preview
            </a>
            <div class="el hint">
                <i class="fa fa-info-circle"></i>
                <div class="text">
                    Please check the ordering section to make sure elements are shown on site.
                    Only elements under the blue sections will appear on site.
                </div>
            </div>
            <a href="/modules/FormBuilder/admin/preview.php"
               id="previewCallLink"
               class="hideme"
               v-preview-overlay></a>
        </div>
    </form>
</div>
