<?php

    namespace Mtc\Plugins\Clinic\Http\Controllers\Admin;

    use Carbon\Carbon;
    use Illuminate\Http\JsonResponse;
    use Mtc\Modules\Members\Models\Member;
    use Mtc\Modules\Members\Models\MemberNote;
    use Mtc\Plugins\Clinic\Src\Flag;
    use Mtc\Plugins\Clinic\Src\Models\BpTrack;

    class PatientProfileController extends ClinicController
    {
        public function bootstrap($id): JsonResponse
        {
            $member = Member::query()->with('addressBilling')->findOrFail($id);

            $notes = MemberNote::query()
                ->with(['admin_user:id,name'])
                ->where('member_id', $id)->where('is_flag', false)
                ->latest()->limit(5)
                ->get(['id','order_id','content','created_at','admin_user_id'])
                ->map(fn($n) => [
                    'id'          => $n->id,
                    'order_id'    => $n->order_id,
                    'content'     => $n->content,
                    'datetime'    => Carbon::parse($n->created_at)->format('d.m.Y H:i'),
                    'author_name' => optional($n->admin_user)->name,
                ])->values();

            // SAFE: work with objects or arrays uniformly
            $flags = Flag::getPatientFlags($id)->map(function ($f) {
                $get = function ($item, $key) {
                    if (is_array($item))   { return $item[$key] ?? null; }
                    if (is_object($item))  { return $item->$key ?? null; }
                    return null;
                };
                return [
                    'id'         => $get($f, 'id'),
                    'content'    => $get($f, 'content'),
                    'status'     => $get($f, 'status'),
                    'author'     => $get($f, 'author') ?? 'System',
                    'datetime'   => $get($f, 'datetime'),
                    'flag_due'   => $get($f, 'flag_due'),
                    'flagColour' => $get($f, 'flagColour'),
                    'flagDue'    => $get($f, 'flagDue'),
                    'system'     => (bool) ($get($f, 'system')),
                ];
            })->values();

            $bp = BpTrack::query()
                ->where('member_id', $id)->latest()->limit(3)
                ->get(['id','low','high','heart_rate','date_provided'])
                ->map(fn($r) => [
                    'id'          => $r->id,
                    'low'         => $r->low,
                    'high'        => $r->high,
                    'heart_rate'  => $r->heart_rate,
                    'date_provided' => Carbon::parse($r->date_provided)->format('d/m/Y'),
                ])->values();

            $attributesValues = \Mtc\Modules\Members\Models\MemberAttribute::unpackDataForForm($member);

            return response()->json([
                'member' => [
                    'id'        => $member->id,
                    'firstname' => $member->addressBilling->firstname ?? '',
                    'lastname'  => $member->addressBilling->lastname ?? '',
                ],
                'notes'      => $notes,
                'flags'      => $flags,
                'bp'         => $bp,
                'attributes' => $attributesValues,
                'todayDate'  => Carbon::now()->format('d/m/Y'),
            ])->setPublic()
                ->setEtag(md5((string) $member->updated_at . $notes->count() . $flags->count() . $bp->count()))
                ->setMaxAge(60);
        }
    }
