Vue.component('patientConsultations', {
    props: ['routes','events'],

    data: function() {
        return {
            records: [],          // always keep as array
            loading: false,
            display: 3,
            todayDate: null,
            showingAll: false,
        };
    },

    mounted() {
        this.init();
    },

    computed: {
        canShowAll() {
            const list = Array.isArray(this.records) ? this.records : [];
            if (!list.length) return false;
            if (this.showingAll) return false;
            return list.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },

        load() {
            this.loading = true;
            const vm = this;

            this.$http.post(this.routes['admin-patient-consultations-load'], {})
                .then((response) => {
                    let payload = response.data;

                    // vue-resource 0.9.x may return JSON as a string
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-patient-consultations-load', e, payload);
                            payload = {};
                        }
                    }

                    const list  = Array.isArray(payload?.consultations) ? payload.consultations : [];
                    const today = payload?.todayDate ?? null;

                    vm.records   = list;      // keep as array
                    vm.todayDate = today;
                    vm.loading   = false;
                })
                .catch((err) => {
                    console.error('Consultations load failed:', err);
                    this.loading = false;
                    this.records = [];        // avoid undefined in render
                });
        },

        showAll() {
            this.showingAll = true;
        },
    },
});
