Vue.component('patientFlags', {

    props: [
        'routes',
        'initialFlags'
    ],

    data: function() {
        return {
            flags: this.initialFlags || [],
            hasLoaded: !!(this.initialFlags && this.initialFlags.length),
            loading: false,
            add: false,
            errors: {},
            success: false,
            display: 5,
            flag: '',
            isTask: false,
            deleteIndex: -1,
        };
    },

    mounted: function() {
        if (!this.hasLoaded) this.load();
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-member-notes-load-flags'], [])
                .then((response) => {

                    let payload = response.data;
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); } catch (e) { console.error('flags load invalid JSON', e, payload); payload = {}; }
                    }
                    vm.flags = Array.isArray(payload?.flags) ? payload.flags : [];
                    vm.loading = false;
                })
                .catch(err => {
                    console.error('flags load failed', err);
                    this.loading = false;
                    this.flags = []; // keep array to avoid render errors
                });
        },
        addFlag() {
            this.add = true;
        },
        cancel() {
            this.add = false;
        },
        store() {
            if (this.loading) return;

            this.errors = {};
            this.success = false;
            this.loading = true;

            const vm = this;

            this.$http.post(this.routes['admin-member-notes-store'], {
                note: this.flag,
                isTask: this.isTask ? '1' : '0',
                flagDue: $('#flagDue').val(),
                isFlag: 1,
            })
                .then((response) => {
                    let payload = response.data;
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); } catch { payload = {}; }
                    }

                    if (payload.errors) {
                        vm.errors = payload.errors;
                        vm.loading = false;
                        return;
                    }
                    if (payload.success) {
                        vm.success = payload.success;
                    }
                    vm.flag = '';
                    vm.add = false;
                    vm.load();
                    vm.emitEvent('flagsChanged');
                })
                .catch(err => {
                    console.error('flag store failed', err);
                    this.loading = false;
                });
        },
        showConfirmDeletion(index) {
            this.deleteIndex = index;
        },
        deleteFlag(id) {
            if (this.loading) return;
            this.errors = {};
            this.success = false;
            this.loading = true;

            const vm = this;

            this.$http.post(this.routes['admin-member-notes-delete-flag'], { id })
                .then((response) => {
                    let payload = response.data;
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); } catch { payload = {}; }
                    }

                    if (payload.errors) {
                        vm.errors = payload.errors;
                        this.loading = false;
                        return;
                    }
                    if (payload.success) {
                        vm.success = payload.success;
                    }
                    vm.showConfirmDeletion(-1);
                    vm.load();
                    vm.emitEvent('flagsChanged');
                })
                .catch(err => {
                    console.error('flag delete failed', err);
                    this.loading = false;
                });
        },
        toggleStatus(id, status) {
            if (this.loading) return;
            this.errors = {};
            this.loading = true;

            const vm = this;

            this.$http.post(this.routes['admin-member-notes-toggle-flag-status'], { id, status })
                .then((response) => {
                    let payload = response.data;
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); } catch { payload = {}; }
                    }

                    this.loading = false;

                    if (payload.errors) {
                        vm.errors = payload.errors;
                        return;
                    }
                    if (payload.success) {
                        const list = Array.isArray(vm.flags) ? vm.flags : [];
                        for (let i = 0; i < list.length; i++) {
                            if (String(list[i].id) === String(id)) {
                                vm.$set(list[i], 'status', status);
                                break;
                            }
                        }
                        vm.flags = list; // ensure stays an array
                        vm.emitEvent('flagsChanged');
                    }
                })
                .catch(err => {
                    console.error('toggle flag failed', err);
                    this.loading = false;
                });
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
