Vue.component('patientMessages', {
    props: ['routes','events'],

    data() {
        return {
            records: [],        // always an array
            loading: false,
            display: 3,
            showingAll: false,
        };
    },

    mounted() {
        this.init();
    },

    computed: {
        canShowAll() {
            const list = Array.isArray(this.records) ? this.records : [];
            if (!list.length) return false;
            if (this.showingAll) return false;
            return list.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },

        load() {
            this.loading = true;
            const vm = this;

            this.$http.post(this.routes['admin-patient-messages-load'], {})
                .then((response) => {
                    let payload = response.data;

                    // vue-resource 0.9.x may return JSON as a string
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-patient-messages-load:', e, payload);
                            payload = {};
                        }
                    }

                    vm.records = Array.isArray(payload?.threads) ? payload.threads : [];
                    vm.loading = false;
                })
                .catch((err) => {
                    console.error('Messages load failed:', err);
                    this.loading = false;
                    this.records = []; // keep array to avoid render errors
                });
        },

        showAll() {
            this.showingAll = true;
        },

        toggleMessages(index) {
            const list = Array.isArray(this.records) ? this.records : [];
            const row = list[index];
            if (!row) return; // guard bad index

            if (typeof row.visible === 'undefined') {
                this.$set(row, 'visible', true);
            } else {
                this.$set(row, 'visible', !row.visible);
            }
        }
    },
});
