Vue.component('patientNotes', {
    props: ['routes','events','initialNotes'],

    data() {
        return {
            notes: this.initialNotes ||[],
            hasLoaded: !!(this.initialNotes && this.initialNotes.length),
            loading: false,
            errors: {},
            success: false,
            display: 5,
            eventIndex: 0,
        };
    },

    mounted() {
        if (!this.hasLoaded) this.load();
    },

    watch: {
        events(stack) {
            for (let i = this.eventIndex; i < stack.length; i++) {
                const event = stack[i];
                if (event.name === 'newNoteAdded') {
                    this.load();
                }
            }
            this.eventIndex = stack.length;
        }
    },

    computed: {
        canLoadMore() {
            const list = Array.isArray(this.notes) ? this.notes : [];
            if (!list.length) return false;
            return list.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },

        load() {
            this.loading = true;
            const vm = this;

            this.$http.post(this.routes['admin-member-notes-load'], {})
                .then((response) => {
                    let payload = response.data;

                    // vue-resource may return JSON as a string
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-member-notes-load:', e, payload);
                            payload = {};
                        }
                    }

                    vm.notes   = Array.isArray(payload?.notes) ? payload.notes : [];
                    vm.loading = false;
                })
                .catch((err) => {
                    console.error('Notes load failed:', err);
                    vm.loading = false;
                    vm.notes = []; // keep array to avoid render errors
                });
        },

        loadMore() {
            this.display += 5;
        },

        addNoteAction() {
            this.emitEvent('initAddNote');
        },

        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
