Vue.component('patientOrders', {

    props: [
        'routes',
        'events',
    ],

    data: function() {
        return {
            orders: [],
            loading: false,
            errors: {},
            success: false,
            display: 3,
            eventIndex: 0,
        };
    },

    watch: {
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'orderCreated') {
                    this.load();
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        }
    },

    mounted: function() {
        this.init();
    },

    computed: {
        canLoadMore() {
            const list = Array.isArray(this.orders) ? this.orders : [];
            return list.length > this.display;
        }
    },

    methods: {
        init() {
            this.load();
        },
        load() {
            this.loading = true;
            const vm = this;

            this.$http.post(this.routes['admin-member-orders-load'], {})
                .then((response) => {
                    // vue-resource sometimes gives a JSON string
                    let payload = response.data;
                    if (typeof payload === 'string') {
                        try {
                            payload = JSON.parse(payload);
                        } catch (e) {
                            console.error('Invalid JSON from admin-member-orders-load:', e, payload);
                            payload = {};
                        }
                    }

                    const orders = Array.isArray(payload?.orders) ? payload.orders : [];
                    vm.orders = orders;                 // always an array
                    vm.loading = false;
                    vm.emitEvent('ordersLoaded');
                    vm.bindModals();
                })
                .catch((err) => {
                    console.error('Orders load failed:', err);
                    vm.loading = false;
                    vm.orders = [];                     // keep it an array to avoid render errors
                    vm.errors.load = 'Failed to load orders.';
                });
        },
        addOrderAction(orderId) {
            this.emitEvent('initBasketBuilder', {
                orderId: orderId > 0 ? orderId : null,
            });
        },
        loadMore() {
            this.display += 10;
            this.emitEvent('ordersLoaded');
            this.bindModals();
        },
        addNoteAction(id) {
            this.emitEvent('initAddNote', {
                orderID: id,
            })
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
        bindModals() {
            this.$nextTick(function () {
                $('.viewOrderButton').mtcOverlay({
                    onClose() {

                    },
                    onOpen() {

                    }
                });
            });
        }
    },
});
