Vue.component('patientReviews', {
    props: ['routes','events','patientData'],

    data() {
        return {
            patient: {},
            reviews: [],     // keep as array
            types: [],
            mediums: [],
            loading: false,
            display: 5,
            eventIndex: 0,
            component: 'reviews',
        };
    },

    mounted() {
        this.init();
    },

    computed: {
        canLoadMore() {
            const list = Array.isArray(this.reviews) ? this.reviews : [];
            if (!list.length) return false;
            return list.length > this.display;
        }
    },

    watch: {
        events(stack) {
            for (let i = this.eventIndex; i < stack.length; i++) {
                const event = stack[i];
                if (event.name === 'reviewsUpdated') {
                    this.load();
                }
            }
            this.eventIndex = stack.length;
        }
    },

    methods: {
        init() {
            this.patient = this.patientData || {};
            this.load();
        },

        load() {
            this.loading = true;
            const vm = this;

            this.$http.post(this.routes['admin-reviews-load'], {})
                .then((response) => {
                    let payload = response.data;

                    // vue-resource may return JSON as a string
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-reviews-load:', e, payload);
                            payload = {};
                        }
                    }

                    vm.reviews = Array.isArray(payload?.reviews) ? payload.reviews : [];
                    vm.loading = false;
                    vm.emitEvent('reviewsLoaded');
                })
                .catch((err) => {
                    console.error('Reviews load failed:', err);
                    vm.loading = false;
                    vm.reviews = []; // avoid undefined in render
                });
        },

        loadMore() {
            this.display += 5;
            this.emitEvent('reviewsLoaded');
        },

        editReviewAction(id) {
            this.emitEvent('initReview', { reviewId: id > 0 ? id : null });
        },

        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
