Vue.component('patientTreatmentPlan', {
    props: ['routes','events'],

    data: function() {
        return {
            treatments: [],      // always an array
            loading: false,
            add: false,
            showAll: false,
            eventIndex: 0,
        };
    },

    mounted() {
        this.init();
    },

    computed: {
        canLoadAll() {
            const list = Array.isArray(this.treatments) ? this.treatments : [];
            return list.length > 1 && !this.showAll;
        },
        activeTreatment() {
            const list = Array.isArray(this.treatments) ? this.treatments : [];
            if (!list.length) return null;
            // tolerate nulls/partials
            for (let i = 0; i < list.length; i++) {
                const t = list[i];
                if (t && t.status === 'active') return t;
            }
            return null;
        },
    },

    watch: {
        events(stack) {
            for (let i = this.eventIndex; i < stack.length; i++) {
                const event = stack[i];
                if (event.name === 'treatmentSaved' || event.name === 'treatmentDeleted') {
                    this.load();
                }
            }
            this.eventIndex = stack.length;
        }
    },

    methods: {
        init() {
            this.load();
        },

        editTreatmentAction(treatment) {
            // Ensure defaultTreatment exists somewhere in scope
            if (typeof treatment === 'undefined') {
                if (typeof defaultTreatment === 'undefined') {
                    // fallback to a minimal empty object to avoid runtime errors
                    treatment = { status: null };
                } else {
                    treatment = defaultTreatment;
                }
            }
            this.emitEvent('initEditTreatment', { treatment });
        },

        cancel() {
            this.add = false;
        },

        load() {
            this.loading = true;
            const vm = this;

            this.$http.post(this.routes['admin-patient-treatments-load'], {})
                .then((response) => {
                    let payload = response.data;

                    // vue-resource 0.9.x can return a JSON string
                    if (typeof payload === 'string') {
                        try { payload = JSON.parse(payload); }
                        catch (e) {
                            console.error('Invalid JSON from admin-patient-treatments-load', e, payload);
                            payload = {};
                        }
                    }

                    const list = Array.isArray(payload && payload.treatments) ? payload.treatments : [];
                    vm.treatments = list;   // keep it an array
                    vm.loading = false;
                    vm.emitEvent('treatmentsLoaded');
                })
                .catch((err) => {
                    console.error('Treatments load failed:', err);
                    vm.loading = false;
                    vm.treatments = [];     // avoid undefined in render
                });
        },

        loadAll() {
            this.showAll = true;
        },

        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
