<?php
namespace Mtc\Migrations;

use Mtc\Core\Models\MigrationTemplate;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\Builder as SchemaBuilder;


class AddLNIDChecksTables implements MigrationTemplate
{

    public function up(SchemaBuilder $schema)
    {
        if (!$schema->hasTable('log_id_checks')) {
            $schema->create('log_id_checks', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('order_id')->index();
                $table->integer('member_id')->index();
                $table->tinyInteger('passed')->index();
                $table->text('request');
                $table->text('response');
                $table->string('endpoint');
                $table->timestamps();
            });
        }

        if (!$schema->hasColumn('members', 'passed_id_check')) {
            $schema->table('members', function (Blueprint $table) {
                $table->dateTime('passed_id_check')->index()->nullable();
            });
        }

        if (!$schema->hasColumn('order', 'failed_id_check')) {
            $schema->table('order', function (Blueprint $table) {
                $table->dateTime('failed_id_check')->index()->nullable();
            });
        }

        return true;
    }

    public function getDescription()
    {
        return 'Add ID Check tables for LexusNexus IDU service';
    }

    public function down(SchemaBuilder $schema)
    {

    }

    public function getPrettyName()
    {
        return 'Add ID Check Tables tables';
    }

}
