<?php
namespace Mtc\Migrations;

use Mtc\Core\Models\MigrationTemplate;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\Builder as SchemaBuilder;


class AddRefundsTables implements MigrationTemplate
{

    public function up(SchemaBuilder $schema)
    {
        if (!$schema->hasTable('order_refunds')) {
            $schema->create('order_refunds', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('order_id')->index();
                $table->decimal('delivery_refund_amount');
                $table->string('reference');
                $table->string('note');
                $table->timestamps();
            });
        }

        if (!$schema->hasTable('order_refund_items')) {
            $schema->create('order_refund_items', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('refund_id')->index();
                $table->integer('order_id')->index();
                $table->integer('order_item_id')->index();
                $table->integer('item_id')->index();
                $table->integer('quantity');
                $table->decimal('amount_refunded');
                $table->timestamps();
            });
        }

        return true;
    }

    public function getDescription()
    {
        return 'Add Refund and RefundItem tables';
    }

    public function down(SchemaBuilder $schema)
    {

    }

    public function getPrettyName()
    {
        return 'Add Refund tables';
    }

}
