<?php
/**
 * Static Block Listing page
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\StaticBlocks\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page['title'] = 'Manage Static Blocks';
$is_admin = false;
if ($adminuser->user['id'] == MTCADMIN_USERID) {
    $is_admin = true;
}

if (!empty($_REQUEST['action'])
    && !empty($_REQUEST['delete_id'])
    && $_REQUEST['action'] == 'delete'
    && $_REQUEST['delete_id'] > 0
    && $is_admin) {
    StaticBlocks::destroy($_REQUEST['delete_id']);
    $message = 'Block deleted';
}

if (!empty($_REQUEST['action'])
    && !empty($_REQUEST['block_id'])
    && $_REQUEST['action'] == 'change_published'
    && $_REQUEST['block_id'] > 0) {

    $block = StaticBlocks::find($_REQUEST['block_id']);
    if (isset($_REQUEST['value']) && in_array($_REQUEST['value'], [0, 1])) {
        $block->published = (int) $_REQUEST['value'];
        $block->save();
        $message = 'Block changed';
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage blocks</li>
</ul>

<h1>Manage Static Blocks</h1>

<?php
require 'tabnav.php';
$blocks = StaticBlocks::all();

if (!empty($message) && isset($_REQUEST['action'])) {
    echo showmsg($message, "success", $path);
}
?>
<form action="<?= $_SERVER['PHP_SELF']; ?>" method="post">
    <?php
    if (count($blocks) > 0) {
        ?>
        <table class="manage-items">
            <tr>
                <th>Block ID</th>
                <th>Name</th>
                <th class="center">Active</th>
                <th class="center">Edit</th>
                <?php
                if ($is_admin) {
                    ?>
                    <th class="center">Delete</th>
                    <?php
                }
                ?>
            </tr>
            <tbody class="tabular">

                <?php
                foreach ($blocks as $block) {
                        ?>
                        <tr>
                            <td>
                                <a href="edit.php?id=<?= clean_page($block->id); ?>">
                                    <?= clean_page($block->id); ?>
                                </a>
                            </td>
                            <td>
                                <a href="edit.php?id=<?= clean_page($block->id); ?>">
                                    <?= clean_page($block->name); ?>
                                </a>
                            </td>
                            <td class="center">
                                <?php
                                if ($block->published) {
                                    $params = [
                                        'action' => 'change_published',
                                        'value' => 0,
                                        'block_id' => clean_page($block->id),
                                    ];
                                    if (!empty($_REQUEST['page'])) {
                                        $params['page'] = clean_page($_REQUEST['page']);
                                    }
                                    ?>
                                    <a href="index.php?<?= http_build_query($params) ?> ?>"
                                        class="alert error"
                                        title="Are you sure you want to unpublish this block?">
                                        <i class="fa fa-check"></i>
                                    </a>
                                    <?php
                                } else {
                                    $params = [
                                        'action' => 'change_published',
                                        'value' => 1,
                                        'block_id' => clean_page($block->id),
                                    ];
                                    if (!empty($_REQUEST['page'])) {
                                        $params['page'] = clean_page($_REQUEST['page']);
                                    }
                                    ?>
                                    <a href="index.php?<?= http_build_query($params) ?>">
                                        <i class="fa fa-square-o"></i>
                                    </a>
                                    <?php
                                }
                                ?>
                            </td>
                            <td class="center">
                                <a href="edit.php?id=<?= clean_page($block->id); ?>" class="edit">
                                    <i class="fa fa-pencil"></i>
                                </a>
                            </td>
                            <?php
                            if ($is_admin) {
                                ?>
                                <td class="center">
                                    <?php
                                    $params = [
                                        'action' => 'delete',
                                        'delete_id' => clean_page($block->id),
                                    ];
                                    if (!empty($_REQUEST['page'])) {
                                        $params['page'] = clean_page($_REQUEST['page']);
                                    }
                                    ?>
                                    <a href="index.php?<?= http_build_query($params) ?>"
                                        class="alert error"
                                        title="Are you sure you want to delete this block?">
                                        <i class="fa fa-remove"></i>
                                    </a>
                                </td>
                                <?php
                            }
                            ?>
                        </tr>
                        <?php
                }
                ?>
            </tbody>
        </table>
    <?php
    } else {
        ?>
        <p>There are currently no blocks added</p>
        <?php
    }
    ?>
</form>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';