<?php

use Mtc\Shop\Assessment\Form;
use Mtc\Shop\Assessment\Question;
use Mtc\Shop\Item\Size;
use Mtc\Shop\Item;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$form = Form::query()
    ->find($_REQUEST['id']);
/** @var Question $question */
$question = Question::query()
    ->find($_REQUEST['question_id']);

$title = 'Manage Recommended Products';
$errors = [];

$breadcrumbs = [
    '/admin/' => 'Home',
    'manage.forms.php' => 'Manage Assessment Forms',
    'manage.form.php?id=' . $form->id => $form->name,
    'manage.question.php?' . http_build_query($_GET) => 'Manage Question',
    '' => $title,
];

if ($question->question_type === 'variations') {
    $variations = json_decode($question->variations, true);
} elseif (in_array($question->question_type, ['yes_no', 'notify_gp', 'yes'], true)) {
    $variations = [
        'Yes',
        'No',
    ];
} else {
    $variations = [];
    $errors = ['This question does not have variations, please go back'];
}

$recommendedItems = $question->recommended ?: [];

require_once $path . 'core/admin/templates/adminheader.html.php';
include __DIR__ . '/breadcrumbs.php';
?>
    <h1><?= $title; ?></h1>
<?php

if (count($errors) > 0) {
    showerrors($errors);
}
?>

    <form action="" method="post" class="style">

        <div class="js-vue-environment p">
            <div style="padding-bottom:20px;">
                Form: <strong><?= clean_page($form->name); ?></strong>
            </div>
            <div style="padding-bottom:20px;">
                Question: <strong><?= strip_tags($question->question_text); ?></strong>
            </div>
            <?php

            $params = [
                'title' => $title,
                'form' => $form,
                'question' => $question,
                'variations' => json_encode($variations),
                'items' => json_encode($question->recommended ?: []),
                'query' => http_build_query($_GET),
                'type' => 'recommend',
            ];

            echo template('/admin/products/recommended.twig', $params);

            $params['type'] = 'exclude';
            $params['items'] = json_encode($question->excluded ?: []);

            echo '<hr />';

            echo template('/admin/products/recommended.twig', $params);

            ?>
        </div>
    </form>
    <style>

        .pointerCursor {
            cursor: pointer;
        }

        .positionRelative {
            position: relative;
        }

        .recommendedList {
            width: 100%;
            margin: 20px 0;
        }
        .recommendedList th, .recommendedList td {
            padding: 10px;
            border: 1px solid #CCC;
        }

        .searchResults {
            position: absolute;
            left: 16%;
            top: 40px;
            z-index: 10;
            min-width: 40%;
            border: 1px solid #CCC;
            box-shadow: 5px 5px 5px #CCC;
        }

        .searchResults th {
            background-color: #dfe5ed;
            white-space: nowrap;
        }

        .searchResults table.manage-items {
            margin-bottom: 0;
        }

        .clearItemSearch {
            position: absolute;
            margin-right: 10px;
            top: 7px;
            right: 44%;
            cursor: pointer;
        }

        .buttonBlock {
            padding-top:40px;
        }
    </style>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
