Vue.component('display-tags-manager', {

    props: [
        "dataUrl",
        "saveDataUrl",
        "availableIcons",
        "allowedTags",
    ],


    data: function() {
        return {
            data: [],
            newDisplayTag: "",
            isBusy: false,
        };
    },


    created: function() {
        this.fetchData();
    },


    methods: {

        fetchData: function() {
            var that = this;

            fetch(this.dataUrl, {
                method: 'GET',
            })
            .then(response => response.json())
            .then(data => {
                that.data = data;
            });
        },


        saveData: function() {
            var that = this;

            let submit_data = {
                data: this.data,
            };

            this.isBusy = true;

            fetch(this.saveDataUrl, {
                method: 'POST',
                body: JSON.stringify(submit_data),
                headers: {
                    'Content-Type': 'application/json'
                },
            })
            .then(response => response.json())
            .then(data => {
                that.isBusy = false;
            });
        },


        addNewDataLine: function() {
            if (! this.newDisplayTag.trim()) return;

            this.data.push({
                label: this.newDisplayTag,
            });

            this.newDisplayTag = "";
        },


        deleteDataLine: function(dataLineIndex) {
            this.data.splice(dataLineIndex, 1);
        },

    },

    template: `
        <section>

            <div class="row">
                <label for="display_tag_label">Label</label>

                <select v-model="newDisplayTag" v-if="allowedTags">
                    <option :value="null">--- select ---</option>
                    <option v-for="allowedTag in allowedTags" v-text="allowedTag.label" :value="allowedTag.label"></option>
                </select>

                <input type="text"
                       v-model="newDisplayTag"
                       v-else
                       class="long" />

                <button
                    @click.prevent="addNewDataLine"
                    class="btn btn-secondary"
                >Add new tag</button>
            </div>

            <table class="manage-items" border="0">

                <thead>
                    <tr>
                        <th>Tag</th>
                        <th>Icon selector</th>
                        <th>Icon</th>
                        <th width="10%">Actions</th>
                    </tr>
                </thead>


                <tbody class="tabular">

                    <tr v-for="(dataLine,d) in data">
                        <td>
                            <input
                                type="text"
                                v-model="dataLine.label"
                                class="long"
                            />

                        </td>
                        <td>
                            <select v-model="dataLine.icon_id">
                                <option :value="null">--- select ---</option>
                                <option v-for="availableIcon in availableIcons" v-text="availableIcon.label" :value="availableIcon.id"></option>
                            </select>
                        </td>
                        <td>
                            <div v-if="dataLine.icon_id">
                                <img :src="availableIcons[dataLine.icon_id].file_url" />
                            </div>
                        </td>
                        <td>
                            <span class="error">
                                <i class="fa fa-times-circle" @click="deleteDataLine(d)"></i>
                            </span>

                        </td>
                    </tr>

                </tbody>

            </table>

            <div class="row">
                <button
                    @click.prevent="saveData"
                    class="btn btn-secondary"
                    v-text="isBusy ? 'Saving...' : 'Save display tags'"
                    :disabled="isBusy"
                ></button>
            </div>

        </section>
    `,

});
