<?php

use Mtc\Core\Permissions;
use Mtc\Shop\Coupon;
use Mtc\Shop\Category;


init_request_values([
    'approval_status' => null,
    'product_type' => null,
    'doctor_note' => null,
    'pharmacist_note' => null,
    'contact_no' => null,
    'date_of_birth' => null,
    'shipment_created' => null,
]);

?>

<form action="<?= \Util::add_query_arg([]) ?>" method="GET" class="style">

    <fieldset <?= Permissions::can(Permissions::DOCTOR_ORDER_VIEW) ? 'class="show"' : ''; ?>>
        <h1><a class="show el">Search orders <i class="fa fa-caret-right"></i></a></h1>
        <div class="row">
            <p>Use * to match any character or sequence of characters in a search</p>
            <label for="">Order Status</label>
            <select name="status">
                <option value="">All</option>
                <?php
                foreach ($orders_statuses as $statusid => $status_name) {
                    if ($statusid . "" == $_REQUEST['status']) {
                        ?>
                        <option value="<?php echo $statusid; ?>" selected><?php echo $status_name; ?></option>
                        <?php
                    } else {
                        ?>
                        <option value="<?php echo $statusid; ?>"><?php echo $status_name; ?></option>
                        <?php
                    }
                }
                ?>
            </select>
        </div>
        <div class="row">
            <label for="">Approval Status</label>
            <select name="approval_status">
                <option value="">All</option>
                <option value="approved" <?= $_REQUEST['approval_status'] === 'approved' ? 'selected' : ''; ?>>Approved</option>
                <option value="not_approved" <?= $_REQUEST['approval_status'] === 'not_approved' ? 'selected' : ''; ?>>Not Approved</option>
            </select>
        </div>
        <?php
        if (!Permissions::can(Permissions::DOCTOR_ORDER_VIEW)) {
            if (defined("TRUSTPILOT_API_ENABLED") && TRUSTPILOT_API_ENABLED == true) {
            ?>
            <div class="row">
                <label for="trustpilot_status">Trustpilot Status</label>
                <select name="trustpilot_status" id="trustpilot_status">
                    <option value="all">All</option>
                    <option value="sent"<?= $_REQUEST['trustpilot_status'] === 'sent' ? ' selected' : '' ?>>Sent</option>
                    <option value="not_sent"<?= $_REQUEST['trustpilot_status'] === 'not_sent' ? ' selected' : '' ?>>Not Sent</option>
                </select>
            </div>
            <?php
            }
            ?>

            <div class="row">
                <label for="">Order ID</label><input type="text" name="id" value="<?= clean_page($_REQUEST['id']); ?>">
            </div>

            <div class="row">
                <label for="product_type">Contains Products of Type</label>
                <select name="product_type" id="product_type">
                    <option value="">Any</option>
                    <option value="general" <?= $_REQUEST['product_type'] === 'general' ? 'selected' : ''; ?>>
                        General
                    </option>
                    <?php
                    foreach (\Mtc\Shop\Item::$product_types as $type => $name) {
                        $selected = $type === $_REQUEST['product_type'] ? 'selected' : '';
                        echo "<option value='{$type}' {$selected}>" . clean_page($name) . "</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="row">
                <label for="doctor_note">Doctor Note</label>
                <select name="doctor_note" id="doctor_note">
                    <option value="">Any</option>
                    <option value="not_empty" <?= $_REQUEST['doctor_note'] === 'not_empty' ? 'selected' : ''; ?>>Not Empty</option>
                    <option value="empty" <?= $_REQUEST['doctor_note'] === 'empty' ? 'selected' : ''; ?>>Empty</option>
                </select>
            </div>

            <div class="row">
                <label for="pharmacist_note">Pharmacy Note</label>
                <select name="pharmacist_note" id="pharmacist_note">
                    <option value="">Any</option>
                    <option value="not_empty" <?= $_REQUEST['pharmacist_note'] === 'not_empty' ? 'selected' : ''; ?>>Not Empty</option>
                    <option value="empty" <?= $_REQUEST['pharmacist_note'] === 'empty' ? 'selected' : ''; ?>>Empty</option>
                </select>
            </div>

            <?php if (COUPON_ENABLED) { ?>
                <div class="row">
                    <label for="">Coupon</label>
                    <select name="coupon">
                        <option value="">All</option>
                        <?php
                        $coupons = Coupon::query()->orderBy('id', 'DESC')->get();
                        foreach ($coupons as $coupon) {
                            $selected = (isset($_REQUEST['coupon']) && $coupon->code == $_REQUEST['coupon']) ? "selected" : "";
                            echo "<option value='" . clean_page($coupon->code) . "' $selected>" . clean_page($coupon->name) . '-' . clean_page($coupon->code) . "</option>";
                        }
                        ?>
                    </select>
                </div>
                <?php
            }
            if (CATEGORIES_MAX > 0) {
                ?>
                <div class="row">
                    <label for="">Category</label>
                    <select name="category">
                        <option value="">All</option>
                        <?php
                        if (count($allowed_categories)) {
                            $categories = Category::query()->whereIn('id', $allowed_categories)->get();
                            foreach ($categories as $category) {
                                ?>
                                <option value="<?= (int)$category->id ?>"
                                    <?= $_REQUEST['category'] == $category->id ? 'selected' : '' ?>>
                                    <?= clean_page($category->name) ?>
                                </option>
                                <?php
                            }
                        } else {
                            echo get_the_categories($_REQUEST['category']);
                        }
                        ?>
                    </select>
                </div>
            <?php } ?>
            <?php
        }
        ?>
        <div class="row">
            <label for="firstname">
                Customer First Name
            </label>
            <input type="text"
                   name="firstname"
                   id="firstname"
                   value="<?= clean_page($_REQUEST['firstname']); ?>"
            >
            <div class="defaultValue">
                <small>
                    Use complete value for search, partial search is not available
                </small>
            </div>
        </div>
        <div class="row">
            <label for="lastname">
                Customer Last Name
            </label>
            <input type="text"
                   name="lastname"
                   id="lastname"
                   value="<?= clean_page($_REQUEST['lastname']); ?>"
            >
            <div class="defaultValue">
                <small>
                    Use complete value for search, partial search is not available
                </small>
            </div>
        </div>
        <div class="row">
            <label for="contact_no">
                Customer Phone Number
            </label>
            <input type="text"
                   name="contact_no"
                   id="contact_no"
                   value="<?= clean_page($_REQUEST['contact_no']); ?>"
            >
            <div class="defaultValue">
                <small>
                    Use complete value for search, partial search is not available
                </small>
            </div>
        </div>
        <div class="row">
            <label for="email">
                Customer Email
            </label>
            <input type="text"
                   name="email"
                   id="email"
                   value="<?= clean_page($_REQUEST['email']); ?>"
            >
            <div class="defaultValue">
                <small>
                    Use complete value for search, partial search is not available
                </small>
            </div>
        </div>
        <div class="row">
            <label for="date_of_birth">
                Customer Date of Birth
            </label>
            <input type="text"
                   name="date_of_birth"
                   id="date_of_birth"
                   placeholder="dd/mm/yyyy e.g. 06/07/1990"
                   value="<?= clean_page($_REQUEST['date_of_birth']); ?>"
            >
            <div class="defaultValue">
                <small>
                    Use complete value for search, partial search is not available
                </small>
            </div>
        </div>

        <div class="row">
            <label for="postcode">
                Customer Postcode
            </label>
            <input type="text"
                   name="postcode"
                   id="postcode"
                   value="<?= clean_page($_REQUEST['postcode']); ?>"
            >
            <div class="defaultValue">
                <small>
                    Use complete value for search, partial search is not available
                </small>
            </div>
        </div>

        <div class="row">
            <label for="">Start Date</label>
            <input type="text" name="start_date"
                   value="<?= clean_page($_REQUEST['start_date']); ?>"
                   class="INPUT1 datepicker">
        </div>

        <div class="row">
            <label for="">End Date</label>
            <input type="text" name="end_date"
                   value="<?= clean_page($_REQUEST['end_date']); ?>"
                   class="INPUT1 datepicker">
        </div>
        <div class="row">
            <label for="">Shipment Created</label>
            <select name="shipment_created">
                <option value="">Any</option>
                <option value="yes" <?= $_REQUEST['shipment_created'] === 'yes' ? 'selected' : ''; ?>>Yes</option>
                <option value="no" <?= $_REQUEST['shipment_created'] === 'no' ? 'selected' : ''; ?>>No</option>
            </select>
        </div>
        <?php
        if (config('nhs.enabled') && !Permissions::can(Permissions::REVIEW_NHS_ORDERS)) {
            ?>
            <div class="row">
                <label for="nhs_orders_only">
                    Show NHS orders only
                </label>
                <input type="checkbox"
                       name="nhs_orders_only"
                       value="1"
                    <?= filter_input(INPUT_GET, 'nhs_orders_only') ? 'checked' : '' ?>
                       id="nhs_orders_only"/>

            </div>
            <?php
        }
        ?>
        <?php
        if (config('basketbuilder.enabled')) {
            ?>
            <div class="row">
                <label for="basket_builder">
                    Created via Basket Builder
                </label>
                <input type="checkbox"
                       name="basket_builder"
                       value="1"
                    <?= !empty($_REQUEST['basket_builder']) ? 'checked' : '' ?>
                       id="basket_builder"
                />

            </div>
            <?php
            }
        ?>
        <div class="row">
            <input type="hidden"
                   name="order_type"
                   value="<?= clean_page($order_filter_type) ?>"/>
            <input type="hidden"
                   name="action"
                   value="search"/>
            <input type="submit"
                   value="Search"
                   class="submit"/>
        </div>
    </fieldset>
</form>
