<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Cms\Models\Page as CmsPage;


class ImportCmsPagesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import_cms_pages {file_name} {container_page_id} {master_page_id} {domain}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '...';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $csv_file_name = $this->argument('file_name');
        $container_page_id = (int)$this->argument('container_page_id');
        $master_page_id = (int)$this->argument('master_page_id');
        $domain_to_remove = $this->argument('domain');

        $container_page = CmsPage::find($container_page_id);
        if (! $container_page) {
            throw new \Exception("Container page id:{$container_page_id} not found!");
        }

        $is_first_row = true;
        if (($handle = fopen($csv_file_name, "r")) !== false) {
            $row = 0;
            while (($data = fgetcsv($handle, null, ',', '#')) !== false) {
                $row++;

                if ($is_first_row) {
                    $is_first_row = false;
                    continue;
                }

                $url = $data[0];
                $content = $data[1];

                $this->info("Importing row {$row}: {$url}");

                $url = str_replace("https://www.{$domain_to_remove}/", '', $url);
                $url = rtrim($url, "/");

                $url_parts = explode('-', $url);

                if ($domain_to_remove == 'travelpharm.com') {
                    array_pop($url_parts);
                }
                $title = ucwords(implode(' ', $url_parts));


                $master_page = CmsPage::find($master_page_id);
                if (! $master_page) {
                    throw new \Exception("Master page id:{$master_page_id} not found!");
                }

                $p = $master_page->replicateWithRelations();
                $p->title = $title;
                $p->slug = implode('-', $url_parts);
                $p->updated = date('c');
                $p->sub_id = $container_page_id;
                $p->save();

                $this->info("Created page id:{$p->id} -- {$title}");

                foreach ($p->lists as $list) {
                    foreach ($list->items as $list_item) {
                        foreach ($list_item->data as $list_item_datum) {
                            if ($list_item_datum->name == 'Content')  {
                                $c = '<p>' . implode('</p><p>', preg_split('/\R+/', $content)) . '</p>';
                                $list_item_datum->value = $c;
                                $list_item_datum->save();
                            }
                        }
                    }
                }
            }
            fclose($handle);
        }

        $this->info('Done.');
    }

}
