<?php
$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

require_once ('../libs/Diff/Diff.php');
require_once ('../libs/Diff/Diff/Renderer/Html/RSSideBySide.php');
require_once ('../libs/Diff/Diff/Renderer/Html/Array.php');

$cms_patching = CmsPatching::newInstance()
    ->loadInfo( $cms_root_path."admin/cms_patching/" )
    ->loadConfig( $cms_root_path."admin/cms_patching/config.json" )
;

$response = array(
    'success' => false,
    'html' => '',
    'files_that_are_different_or_modified_on_the_current_system' => array()
);

if ( empty( $_REQUEST ) || empty( $_REQUEST['version'] ) || empty( $_REQUEST['instruction_path'] ) ) {
    die(json_encode($response));
}

$instruction_json = file_get_contents($_REQUEST['instruction_path']);

if ( empty($instruction_json) ) {
    die(json_encode($response));
}

$downloaded_repo_location = SITE_PATH."/../cms-patching/".$_REQUEST['version']."/";
$instruction = CmsPatching::parsePatchingInstructionJson($instruction_json, $downloaded_repo_location, SITE_PATH."/");

if ( empty($instruction) ) {
    die(json_encode($response));
}

$files_that_are_different_or_modified_on_the_current_system = array();

$html = "";
ob_start();

$renderer = new Diff_Renderer_Html_RSSideBySide;

$list = $instruction['file_instructions'];
for ($i=0; $i < count($list); $i++) {

    $filename = $list[$i]['source'];
    $filename_destination = $list[$i]['destination'];

    $fetched_version = false;
    //if ( file_exists($_REQUEST['version']."/".$filename) ) {
    if ( file_exists($filename) ) {
        //if ( is_dir($_REQUEST['version']."/".$filename) ) {
        if ( is_dir($filename) ) {
            $fetched_version = "1"; // or true?
        } else {
            //$fetched_version = file_get_contents($_REQUEST['version']."/".$filename);
            $fetched_version = file_get_contents($filename);
        }
    }
    $current_system_version = false;
    //if ( file_exists(SITE_PATH."/".$filename_destination) ) {
    if ( file_exists($filename_destination) ) {
        //if ( is_dir(SITE_PATH."/".$filename_destination) ) {
        if ( is_dir($filename_destination) ) {
            $current_system_version = "1";
        } else {
            //$current_system_version = file_get_contents(SITE_PATH."/".$filename_destination);
            $current_system_version = file_get_contents($filename_destination);
        }
    }

    $issue = false;
    if ( $fetched_version === false || $current_system_version === false ) {
        $files_that_are_different_or_modified_on_the_current_system[] = $filename;
        $issue = true;
    }

    $file_doesnt_exist_in_version = false;
    if ( $fetched_version === false ) {
        $file_doesnt_exist_in_version = true;
        $fetched_version = "";
    }

    $file_doesnt_exist_in_current_sys = false;
    if ( $current_system_version === false ) {
        $file_doesnt_exist_in_current_sys = true;
        $current_system_version = "";
    }

    $b = explode("\n", $fetched_version);
    $a = explode("\n", $current_system_version);
    $diff = new Diff($a, $b, array('ignoreWhitespace'=>true));
    $html = $diff->Render($renderer);





    $clean_current_commit_system_version_diff_html = false;
    if ( $issue || !empty($html) ) {

        $clean_current_commit_system_version = false;
        //if ( file_exists($_REQUEST['current_sys_commit_hash']."/".$filename_destination) ) {
        if ( file_exists($filename_destination) ) {
            //if ( is_dir($_REQUEST['current_sys_commit_hash']."/".$filename_destination) ) {
            if ( is_dir($filename_destination) ) {
                $clean_current_commit_system_version = "1";
            } else {
                //$clean_current_commit_system_version = file_get_contents($_REQUEST['current_sys_commit_hash']."/".$filename_destination);
                $clean_current_commit_system_version = file_get_contents($filename_destination);
            }
        }

        if ( $clean_current_commit_system_version !== false ) {
            $b = explode("\n", $clean_current_commit_system_version);
            $a = explode("\n", $current_system_version);
            $diff = new Diff($a, $b, array('ignoreWhitespace'=>true));
            $clean_current_commit_system_version_diff_html = $diff->Render($renderer);
        }

    }



    echo "<div class='importantFile ".($issue || !empty($html) ? 'issue' : 'noIssue')." ".(!empty($clean_current_commit_system_version_diff_html) ? 'customIssue' : '')."'>";
        echo "<div class='fileName'>";
            if ( $issue || !empty($html) ) {
                echo "<input
                    type='checkbox'
                    data-filename='".$filename."'
                    data-source='".$list[$i]['source']."'
                    data-destination='".$list[$i]['destination']."'
                    data-mode='".$list[$i]['mode']."'
                    name='update[".$filename."]'
                    id='update[".$filename."]'
                    class='file-to-be-replaced'
                    checked
                />";
            } else {
                echo "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            echo "<label for='update[".$filename."]'>";
                echo $filename_destination;
            echo "</label>";
            if ( $issue == true || !empty($html) ) {
                echo " <a href='#' title='Open' class='open'><i class='fa fa-list-ol'></i>&nbsp;view comparison</a>";
            }
        echo "</div>";

        if ( $file_doesnt_exist_in_version ) {
            echo "<strong>Doesn't exist in version ".$_REQUEST['version'].". This generally shouldn't be the case - someone forgot to update important_files.txt. No action.</strong>";
            $fetched_version = "";
        }

        if ( $file_doesnt_exist_in_current_sys ) {
            if ( $file_doesnt_exist_in_version ) {
                echo "<br/>";
                echo "<strong>ALSO doesn't exist on current system.</strong>";
            } else {
                echo "<strong>Doesn't exist on current system. To be created.</strong>";
            }
        }

        echo "<div class='compare'>";
            echo $html;
        echo "</div>";
    echo "</div>";

}

$html = ob_get_contents();
ob_end_clean();

$response = array(
    'success' => true,
    'html' => $html,
    'files_that_are_different_or_modified_on_the_current_system' => $files_that_are_different_or_modified_on_the_current_system
);

die(json_encode($response));
