<?php

function isSetNotEmpty($value) {

    if (isset($value) && !empty($value)) {
        return true;
    }

    return false;
}

function add_fullcms_image($formats, $size, $original_name, $tmp_name, $mime_regex = '') {

    if ($size <= 0 || !CmsHelper::isFileMimeValid($mime_regex, $tmp_name, $original_name, true)) {
        return false;
    }


    $filename = clean_image_value(time().$original_name);

    // create image resize directory if doesn't exist
    if (!is_dir(SITE_PATH . "/" . $formats['original']['path'])) {
        mkdir(SITE_PATH . "/" . $formats['original']['path'], 0755, true);
    }

    if (!copy($tmp_name, SITE_PATH."/".$formats['original']['path']."/".$filename)) {
        die("Cant copy to:".SITE_PATH."/".$formats['original']['path']."/".$filename.". Directory might not exist.");
    }

    // convery cymk to rgb
    $image_info = getimagesize(SITE_PATH . "/" . $formats['original']['path'] . "/" . $filename);
    if(isset($image_info['channels'])) {
        if ($image_info['channels'] == 4) { // is CMYK
            image_cmyk_to_rgb($formats['original']['path'], $filename);
        }
    }

    $optimize_lossless = IMAGE_OPTIMISE_LOSSLESS;
    // losslessly optimize newly created image if $optimize_lossless is true
    ImageOptimizer::optimizeLosslessly(SITE_PATH . "/" . $formats['original']['path'] . "/" . $filename, $optimize_lossless);

    foreach ($formats as $resize) {

        if (isset($resize['skip']) && $resize['skip']) {
            continue;
        }

        $destination_folder = SITE_PATH . "/" . $resize['path'];

        // create image resize directory if doesn't exist
        if (!is_dir($destination_folder)) {
            mkdir($destination_folder, 0755, true);
        }

        k_resize_image(
            SITE_PATH . "/" . $formats['original']['path'] . "/" . $filename,
            $destination_folder . "/" . $filename,
            (isset($resize['width']) ? $resize['width'] : null),
            (isset($resize['height']) ? $resize['height'] : null),
            (isset($resize['crop']) ? $resize['crop'] : null),
            0,
            (isset($resize['quality']) ? $resize['quality'] : null),
            (isset($resize['crop_position']) ? $resize['crop_position'] : null)
        );
    }

    return $filename;

}

function add_fullcms_file($size, $original_name, $tmp_name,  $mime_regex = '') {

    if ($size <= 0 || !CmsHelper::isFileMimeValid($mime_regex,  $tmp_name, $original_name)) {
        return false;
    }

    $filename = clean_image_value(time() . $original_name);

    $filename_upload_directory = SITE_PATH . "/uploads/files/";

    // create image resize directory if doesn't exist
    if (!is_dir($filename_upload_directory)) {
        mkdir($filename_upload_directory, 0755, true);
    }

    if (!@copy($tmp_name, $filename_upload_directory . $filename)) {
        die("Cant copy to:" . $filename_upload_directory . $filename . ". Directory might not exist.");
    }

    return $filename;

}

function get_mime_ssh($file) {
    $raw = shell_exec("file -ib ".$_FILES['cv']['tmp_name']);
    $array = explode(';', $raw);
    return $array[0];
}

function page_id_in_page_tree($page_id_needle, $page_tree) {

    foreach ($page_tree as $key => $page) {

        if ($key == $page_id_needle) {

            return true;

        } else if (is_array($page['sub'])) {

            if (page_id_in_page_tree( $page_id_needle, $page['sub'])) {
                return true;
            }

        }

    }

    return false;
}


// Generates a random string
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
