<?php

/**
 * Seo helper class
 *
 * @author Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoHelper
{
    /**
     * Helper used with usort to sort 2d array returned from db by length of
     * path field
     *
     * @param array $a
     * @param array $b
     * @return array
     */
    public static function sortByLength($a, $b)
    {
        return strlen($b['path']) - strlen($a['path']);
    }

    /**
     * Checks if the current uri is in the /browse/ module or not
     *
     * @return boolean
     */
    public static function isBrowse()
    {
        if (
            substr($_SERVER['PHP_SELF'], 5, 8) === '/browse/' ||
            substr($_SERVER['PHP_SELF'], 0, 8) === '/browse/' ||
            (
                defined('IS_BROWSE') &&
                IS_BROWSE == true
            )
        ) {
            return true;
        }
        else {
            return false;
        }
    }

    /**
     * Gets product filter in the correct state
     *
     * @return \ProductFilter
     */
    public static function getFilter()
    {
        if ($_SERVER['PHP_SELF'] == '/shop/browse/index.php' || $_SERVER['PHP_SELF'] = '/browse/index.php') {
            $ajax = false;
            $browse_url = $_SERVER['REQUEST_URI'];
        } else {
            $ajax = true;
            $browse_url = $_REQUEST['url'];
        }
        $filter = new ProductFilter($ajax);
        $filter->urlToSelections($browse_url);

        if (isset($_REQUEST['page']) && is_numeric($_REQUEST['page'])) {
            $filter->page = $_REQUEST['page'];
        }

        return $filter;
    }

}
