<?php
/**
 * Admin User
 *
 * Manages Admin User.
 *
 * @author Florin Radica <florin.radica@mtcmedia.co.uk>
 * @since 04/07/2017
 */

namespace Mtc\Core;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Accessors
 *
 * @property int $id
 * @property string $username
 * @property string $password
 * @property string $email
 * @property string $signature
 * @property string $session_id
 * @property string $name
 * @property int $role
 *
 */
class AdminUser extends Model
{
    public $timestamps = false;
    protected $table = 'admin_users';
    protected $fillable = [
        'username',
        'email',
        'signature',
        'session_id',
        'name',
        'role',
        'credentials',
    ];

    public static function getCurrent()
    {
        $legacy_admin_user = new \AdminUser();

        return $legacy_admin_user->eloquent();
    }
}
