#!/bin/sh
# this file assumes it's run from the site root directory

sh core/deploy.sh

if [ -f shop/deploy.sh ]; then
    sh shop/deploy.sh
fi

if [ -f cms/deploy.sh ]; then
    sh cms/deploy.sh
fi


echo "Compiling assets...";

DO_COMPILE_ASSETS=$(git --git-dir=../public_html.git/ diff HEAD@{1}..HEAD --pretty="" --name-only | rev | cut -d . -f 1 | rev | sort | uniq | grep -E "less|css|js|json|vue" | wc -l)

if [[ DO_COMPILE_ASSETS -gt 0 ]]; then
    npm install && npm run production
else
    echo " ...skipping (no asset changes detected)."
fi

