<?php

use Mtc\Modules\BasketRecovery\Classes\BasketRecovery;

?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Manage <?= $page_name ?>s</li>
    </ul>
    <h1>Manage <?= $page_name ?>s</h1>

<?php
require __DIR__ . '/tabnav.php';
?>

<?php
if ($data->isEmpty()) {
    ?>
    <p>No <?= $page_name ?>s have been created.</p>
    <?php

} else {
    ?>
    <table class="manage-items">
        <thead>
        <tr>
            <th class="fieldname">ID</th>
            <th class="fieldname">Is Active?</th>
            <th class="fieldname">Type</th>
            <th class="fieldname">Name</th>
            <th class="fieldname">Interval</th>
            <th class="fieldname">Trigger</th>
            <th class="fieldname">Restrictions</th>
            <th class="center">Preview</th>
            <th class="center">Edit</th>
            <th class="center">Delete</th>
        </tr>
        </thead>

        <tbody class="tabular">
        <?php
        foreach ($data as $item) {
            $params = ['id' => $item->id];
            ?>
            <tr>
                <td><?= $item->id ?></td>
                <td><i class="fa fa-<?= $item->is_active ? 'check-' : '' ?>square-o"></i></td>
                <td><?= clean_page(ucwords($item->type)) ?></td>
                <td>
                    <?= $item->name ?>
                </td>
                <td><?= clean_page($item->interval) ?></td>
                <td>
                    <?php
                    if (array_key_exists($item->trigger, BasketRecovery::$triggers)) {
                        echo clean_page(ucwords(BasketRecovery::$triggers[$item->trigger]));
                    } elseif (strpos($item->trigger, 'status') !== false) {

                        $status = collect(\Mtc\Shop\Order::$statuses)
                            ->filter(function ($status, $key) use ($item) {
                                return $key == str_replace('status_', '', $item->trigger);
                            })
                            ->each(function ($status) {
                                echo "Status Changed To: {$status}";;
                            });
                    }
                    ?>
                </td>
                <td>
                    <?php
                    if ($item->restriction_type) {
                        echo clean_page(BasketRecovery::$restrictions[$item->restriction_type]);
                    }
                    if ($item->restriction_type !== 'all_products') {
                        echo "<br/>";
                        echo $item->getRestrictionName();
                    }
                    ?>
                </td>
                <td class="center">
                    <a target="_blank" href="preview.php?<?= http_build_query($params) ?>">
                        <i class="fa fa-envelope"></i>
                    </a>
                </td>
                <td class="center">
                    <a href="edit.php?<?= http_build_query($params) ?>">
                        <i class="fa fa-pencil"></i>
                    </a>
                </td>
                <td class="center">
                    <a href="?<?= http_build_query(['action' => 'delete', 'id' => $item->id]) ?>"
                       class="alert error"
                       title="Are you sure you want to delete this?">
                        <i class="fa fa-remove"></i>
                    </a>
                </td>
            </tr>
            <?php

        }
        ?>
        </tbody>
    </table>
    <?php

}
