<?php

namespace Mtc\Modules\BlackList\Classes;

use Mtc\Core\Postcode;
use Mtc\Core\PostcodeFactory;
use Mtc\Core\UkPostcode;

class BlackList extends \Illuminate\Database\Eloquent\Model {
    public $timestamps = false;

    protected $fillable = [
        'email',
        'telephone',
        'address'
    ];

    protected $table = 'black_list';

    const SOFT_BLACKLIST_FLAG = 1;
    const HARD_BLACKLIST_FLAG = 2;

    /**
     * @param array $fields
     * @return bool
     */
    public function isBlacklisted(array $fields) {
        // TODO:
        // normalize values
        $query = $this->select('id', 'hard_blacklist');
        foreach ($fields as $field => $value) {

            if($field === 'address') {
                $postcode_normalized = new UkPostcode($value);
                $value = $postcode_normalized;
            }

            // Should not be checking the empty as the blacklist might contain empty DB fields
            if (!empty(trim($value))) {
                $query = $query->orWhere($field, '=', $value);
            }
        }
        if($query->count() > 0){
            if($query->first()->hard_blacklist == 1) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}