<?php
/**
 * @author: Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 * @version: 5/25/2018
 */

namespace Mtc\Plugins\AccountVerifier\Classes;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Mtc\Modules\Members\Models\Member;

class AccountVerifications extends Model
{

    protected $guarded = ['id'];

    /**
     * addresses one-to-many relationship.
     *
     * @return HasOne
     */
    public function member()
    {
        return $this->hasOne(Member::class, 'member_id');
    }

    /**
     * Finds out if the code exists within the time frame of expiration
     *
     * @param $code
     * @return bool
     */
    public static function codeExists($code)
    {
        return self::query()
                ->where('code', $code)
                ->where('created_at', '>', Carbon::now()->subMinutes(AccountVerifier::VERIFICATION_CODE_EXPIRY_MINUTES))
                ->count() > 0;
    }
}