<?php
namespace Mtc\Migrations;

use Mtc\Core\Models\MigrationTemplate;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\Builder as SchemaBuilder;


class AccountVerifyInstall implements MigrationTemplate
{

    public function up(SchemaBuilder $schema)
    {
        if ($schema->hasTable('account_verifications') === false) {
            $schema->create('account_verifications', function (Blueprint $table) {
                $table->increments('id');
                $table->string('code', 50)->index();
                $table->string('type', 10)->index();
                $table->string('email')->index();
                $table->string('phone')->index();
                $table->integer('member_id')->nullable()->default(null)->index();
                $table->dateTime('verified')->nullable()->default(null)->index();
                $table->timestamps();

                $table->engine = 'InnoDB';
            });
        }
        if ($schema->hasTable('account_verifier_settings') === false) {
            $schema->create('account_verifier_settings', function (Blueprint $table) {
                $table->increments('id');
                $table->string('code', 50)->index();
                $table->string('value', 255)->index();
                $table->timestamps();

                $table->engine = 'InnoDB';
            });
        }
        return true;
    }

    public function getDescription()
    {
        return 'Install Account Verifier Plugin';
    }

    public function down(SchemaBuilder $schema)
    {
        return '';
    }

    public function getPrettyName()
    {
        return 'Install Account Verifier Plugin';
    }

}
