<?php

use Mtc\Modules\Members\Models\Member;
use Mtc\Plugins\Judopay\Classes\Judopay;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

header('Content-Type: application/json');

/** @var Member $member */

$basket = new Basket();

$basket->Go_Basket();

$judo = Judopay::getService();
$session = $judo->createSession($basket);
$data = [];
$errors = [];

switch ($_GET['method']) {
    case 'form':
        $address = $basket->address['billing'];
        $data = [
            'ref'       => $session['ref'],
            'config'    => array_merge([
                'challengeRequestIndicator'     => 'challengeAsMandate',
                'scaExemption'                  => 'SecureCorporate',
                'initialRecurringPayment'       => false,
                'billingAddress'                => [
                    'address1'      => $address['address1'],
                    'address2'      => $address['address2'],
                    'town'          => $address['city'],
                    'postcode'      => $address['postcode'],
                    'countryCode'   => 826,            
                ],
            ], $session['data'])
        ];
        break;
    case 'apay':
        $apay = new \Mtc\Plugins\Judopay\Classes\APay($basket);
        $data = [
            'ref'           => $session['ref'],
            'config'        => array_merge([
                'paymentRequest'    => $apay->getPaymentDataRequest(),
            ], $session['data']),
        ];
        break;
    case 'gpay':
        $gpay = new \Mtc\Plugins\Judopay\Classes\GPay($basket);
        $data = [
            'environment'   => config('judopay.testmode') ? 'TEST' : 'PRODUCTION',
            'ref'           => $session['ref'],
            'config'        => $gpay->getPaymentDataRequest(),
        ];
        break;
    default:
        $errors['method'] = 'Unknown Payment Method';
        break;
}

if(empty($errors)) {
    $res = [
        'status'    => 200,
        'data'      => $data,
    ];
} else {
    http_response_code(401);

    $res = [
        'status'    => 401,
        'errors'    => $errors,
    ];
}

echo json_encode($res);
exit();