<?php
namespace Mtc\Plugins\NewsletterSignup\Classes;

/**
 * Interface SignUpInterface
 *
 * @package Mtc\Plugins\NewsletterSignup\Classes
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
interface SignUpInterface
{
    /**
     * Sign up method
     *
     * @param string $email email address to sign up
     * $param array $additional_params any additional params passed to interface
     * @return mixed
     */
    public function signUp($email, $additional_params);

    /**
     * Check if email already exists in the list
     *
     * @param $email
     * @return bool
     */
    public function checkIfExists($email);
}