<?php
chdir(dirname(__FILE__));

// disable this as invitations are sent out manually
return true;

use Mtc\Plugins\TrustpilotAPI\Classes\TrustpilotReview;
use Mtc\Plugins\TrustpilotAPI\Classes\TrustpilotSettings;
use \Illuminate\Database\Capsule\Manager as DB;

$noauth = true;
$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$reviews = TrustpilotReview::where(function ($query) {
    $query->where('send_date', '=', null)
          ->orWhere('send_date', '<=', DB::raw('NOW()'));
})
->where('status', '=', 0)
->take(TrustpilotSettings::getByKey('SEND_BATCH_SIZE'))
->offset(0)
->get();

if (count($reviews) > 0) {
    foreach ($reviews as $review) {
        $subject = 'Your opinion matters';

        $body = $twig->render('email/review.invatation.twig', array(
            'review' => $review
        ));

        //email headers
        $headers  = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        $headers .= 'FROM: "' . config('app.name') .'" <' . config('site.from_email') .'>' . "\r\n";
        $headers .= "Return-Path: " . config('site.contact_email') . "\r\n";
        $headers .= "Reply-To:" . config('site.from_email') . "\r\n";

        //send mail
        if (mail($review->email, $subject, $body, $headers)) {
            $review->status = 1;
            $review->save();
        }
    }
}
