<?php

namespace Mtc\Plugins\Wisebee\Classes\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Accessors
 *
 * @property int $id
 * @property int $wisebee_id
 * @property int $wisebee_consultation_id
 * @property int $wisebee_user_id
 * @property string $status
 * @property string $email
 * @property string $firstname
 * @property string $lastname
 * @property string $type
 * @property string $notes
 * @property string $hash
 * @property string $updated_at
 * @property string $created_at
 *
 */

class WisebeeParticipant extends Model
{
    protected $table = 'wisebee_participants';

    protected $fillable = [
        'wisebee_id',
        'wisebee_consultation_id',
        'wisebee_user_id',
        'status',
        'email',
        'firstname',
        'lastname',
        'type',
        'notes',
        'hash',
    ];

    const TYPE_SPECIALIST = 'specialist';
    const TYPE_COLLEAGUE = 'colleague';
    const TYPE_CUSTOMER = 'customer';
    const TYPE_GUEST = 'guest';

    const STATUS_PENDING = 'pending';
    const STATUS_ACCEPTED = 'accepted';
    const STATUS_DECLINED = 'declined';
    const STATUS_TEMPORARY = 'temporary';
    const STATUS_CANCELLED = 'cancelled';

    /**
     * @return BelongsTo
     */
    public function consultation(): BelongsTo
    {
        return $this->belongsTo(WisebeeConsultation::class, 'wisebee_consultation_id', 'wisebee_id');
    }

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(WisebeeUser::class, 'wisebee_user_id', 'wisebee_id');
    }

    /**
     * @return BelongsTo
     */
    public function customer(): BelongsTo
    {
        return $this->belongsTo(WisebeeMember::class, 'wisebee_user_id', 'wisebee_id');
    }
}