<?php

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;
use Mtc\Plugins\Wisebee\Http\Controllers\WisebeeController;

Route::get('book-a-consultation', [WisebeeController::class, 'book'])
    ->name('wisebee-book');
Route::get('video-consultation', [WisebeeController::class, 'video'])
    ->name('wisebee-consultation');
Route::any('wisebee-webhook', [WisebeeController::class, 'webhook'])
    ->name('wisebee-webhook');

Route::group([
    'prefix' => 'members',
], function () {

    Route::get('consultations', [WisebeeController::class, 'memberConsultations'])
        ->name('members-consultations');
});

Route::group(['middleware' => 'auth'], function() {
    Route::get('document/{id}', function ($id) {
        return App::make(WisebeeController::class)->downloadDocument($id);
    })
        ->name('wisebee-document-download');
});

Route::group([
    'middleware' => 'auth',
    'prefix' => 'admin/wisebee',
], function () {
    Route::get('configuration', [WisebeeController::class, 'configuration'])
        ->name('wisebee-admin-configuration');
    Route::post('configuration', [WisebeeController::class, 'configurationStore'])
        ->name('wisebee-admin-configuration-store');
});