# Pharmacy System Starter - Setup Guide

## **Initial Setup (Server Deployment)**

Follow these steps to set up the project on a traditional server:

1. **Create a folder** on the server, e.g., `public_dev`.
2. **Create a subdomain** in cPanel and link it to `public_dev`.
3. **Clone the repository** into `public_dev`:
   ```sh
   git clone git@bitbucket.org:mtcmedia/pharmacy-system-starter.git public_dev
   ```
4. **Create a database**, database user, and attach the user to the database.
5. **Create `.env` file**:
   ```sh
   cp .env.example .env
   ```
6. **Update database credentials** in `.env`:
   ```dotenv
   DB_DATABASE=your_database_name
   DB_USERNAME=your_database_user
   DB_PASSWORD=your_database_password
   ```
7. **Update `APP_DOMAIN`** in `.env` to match your subdomain.
8. **Update missing IPs** in `/config/whitelist.php`.
9. **Ensure required versions are installed**:
    - **Node.js** version `^16.0`
    - **PHP** version `^8.3`
10. **Run the setup script**:
    ```sh
    sh setup.sh && rm setup.sh
    ```

---

## **Local Setup Using Docker (Optional)**

If you prefer to run the project locally using Docker, follow these steps:

### **Prerequisites**
- Ensure you have **Docker** installed and configured.
- If you haven't installed Docker, follow [this guide](https://docs.docker.com/get-docker/).
- **Windows Users**: Ensure Docker is configured with **WSL**.
- **Mac Users**: Install Docker Desktop for macOS.
- **Linux Users**: Install Docker using your package manager:
  ```sh
  # Ubuntu/Debian
  sudo apt update && sudo apt install docker.io docker-compose -y

  # Fedora
  sudo dnf install docker docker-compose -y
  ```
  After installation, ensure your user has permission to run Docker without `sudo`:
  ```sh
  sudo usermod -aG docker $USER
  ```
  Then restart your session or run:
  ```sh
  newgrp docker
  ```

### **Steps to Run with Docker**
1. **Clone the repository** into your local machine:
   ```sh
   git clone git@bitbucket.org:mtcmedia/pharmacy-system-starter.git ~/pharmacy-starter
   cd ~/pharmacy-starter
   ```
2. **Run the Docker setup script**:
   ```sh
   sh docker-setup.sh
   ```
3. **Once setup is complete**, access the site at:
   ```
   http://localhost
   ```

---

## **Useful Docker Commands**
Here are some common commands for managing the Docker environment:

### **Start the Docker environment** (in detached mode):
```sh
docker compose up -d
```
### **Stop the containers**:
```sh
docker compose down
```
### **View running containers**:
```sh
docker ps
```
### **Restart a specific container** (e.g., PHP container):
```sh
docker restart php-container-name
```
### **Access the PHP container's shell**:
```sh
docker exec -it php-container-name bash
```
### **View logs for debugging**:
```sh
docker compose logs -f
```

---

## **Notes**
- The **Docker setup is optional**; use it only if you prefer local containerized development.
- If running on a server, follow the **Initial Setup (Server Deployment)** section above.
```

## 📚 Additional Documentation
- [Internal Git Workflow](./git_workflow_internal.md)
