<?php
$path = '../../../';
require_once $path .'core/includes/header.inc.php';

$section = 'shop';

$new_zone = new DeliveryMethod();

$page_meta['title'] = 'Add new Shipping Charge';

if (filter_input(INPUT_POST, 'action') == 'add_new') {
    if (!filter_input(INPUT_POST, 'name')) {
        $errors['name'] = 'Zone name is required';
    }

    if (!filter_input(INPUT_POST, 'zone')) {
        $errors['zone'] = 'Zone selection is required';
    }

    if (filter_input(INPUT_POST, 'min') < 0) {
        $errors['min'] = 'Minimum price must be at least 0';
    }

    if (filter_input(INPUT_POST, 'cost') < 0) {
        $errors['cost'] = 'Delivery cost cannot be negative';
    }

    if (filter_input(INPUT_POST, 'max') < filter_input(INPUT_POST, 'min') ) {
        $errors['max'] = 'Maximum price needs to be higher than minimum price';
    }
    //check if unresolved errors from other fields first
    $new_zone->fill($_POST);

    if (empty($errors)) {
            if ($new_zone->save()) {
                // Sets flash message
                $_SESSION['flash_message'] = [
                    "type"    => "success",
                    "message" => 'Delivery method added'
                ];
                header('Location: manage.delivery.php');
                exit;
            }
        }
    }
    require_once $path .'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="manage.delivery.php">Manage</a> /</li>
    <li class="end">Add new Shipping Charge</li>
</ul>

<h1>Edit Delivery Costs</h1>

<ul class="tabnav el">
    <li ><a href="manage.delivery.php">Manage</a></li>
    <li class="selected"><a href="edit.delivery.php">Add new Shipping Charge</a></li>
</ul>
<?php
if (ADMIN_ADD_DELIVERY_METHODS == true) {
    ?>
    <form action="edit.delivery.php" method="POST">
        <fieldset class="show">
            <h1><a class="show el">General Options <i class="fa fa-caret-down"></i></a></h1>

            <div class="row">
                <label for="zone">Delivery Methods</label>
                <select name="zone" id="zone">
                    <?php
                    $zones = DeliveryMethod::distinct('zone')->orderBy('zone')->get(['zone'])->toArray();
                    ?>
                    <option value="0">Choose Zone</option>
                    <?php
                    foreach ($zones as $zone) {
                        ?>
                        <option value="<?= clean_page($zone['zone']) ?>"
                        <?php
                        echo ($new_zone->zone == $zone['zone']) ? 'selected': '';
                            ?>
                        >
                             Zone <?= clean_page($zone['zone']) ?>
                        </option>
                        <?php
                    }
                    ?>
                </select>
            </div>
            <?php if(!empty($errors['zone'])) { ?>
                <div class="row">
                    <p class="error"><?=clean_page($errors['zone'])?></p>
                </div>
            <?php } ?>

            <div class="row">
                <label for="new_name">Name</label>
                <input type="text"
                       name="name"
                       id="new_name"
                       value="<?= clean_page($new_zone->name) ?>"
            </div>
            <?php if(!empty($errors['name'])) { ?>
                <div class="row">
                    <p class="error"><?=clean_page($errors['name'])?></p>
                </div>
            <?php } ?>

            <div class="row">
                <label for="new_min_price">Min Price</label>
                <input type="text"
                       name="min"
                       id="new_min_price"
                       value="<?= clean_page($new_zone->min ?: 0) ?>"
            </div>
            <?php if(!empty($errors['min'])) { ?>
                <div class="row">
                    <p class="error"><?=clean_page($errors['min'])?></p>
                </div>
            <?php } ?>

            <div class="row">
                <label for="new_max_price">Max Price</label>
                <input type="text"
                       name="max"
                       id="new_max_price"
                       value="<?= clean_page($new_zone->max ?: 999999) ?>"
            </div>
            <?php if(!empty($errors['max'])) { ?>
            <div class="row">
                <p class="error"><?=clean_page($errors['max'])?></p>
            </div>
            <?php } ?>

            <div class="row">
                <label for="new_cost">Cost</label>
                <input type="text"
                       name="cost"
                       id="new_cost"
                       value="<?= clean_page($new_zone->cost ?: 0) ?>"
            </div>
            <?php if(!empty($errors['cost'])) { ?>
                <div class="row">
                    <p class="error"><?=clean_page($errors['cost'])?></p>
                </div>
            <?php } ?>

            <p>
                <input type="hidden"
                       name="action"
                       value="add_new"/>
                <input type="submit"
                       value="Add"/>
            </p>

        </fieldset>
    </form>
<?php
}else {
    //redirect away
    header('Location: manage.delivery.php');
    exit;
}
require_once $path .'core/admin/templates/adminfooter.html.php';
