<?php

use App\Admin\OrdersHelper;
use App\Events\OrderTabNavPrintedEvent;
use Carbon\Carbon;
use Mtc\Core\Admin\User;
use Illuminate\Support\Facades\Event;
use Mtc\Core\Permissions;

$start_date = Carbon::now()->subDays(3)->format('d/m/Y');
$end_date = Carbon::now()->format('d/m/Y');

?>
<ul class="tabnav el">
    <li<?php
        if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' &&
            empty($type) &&
            filter_input(INPUT_GET, 'product_type') !== 'consultation')
        {
        ?> class="selected"<?php } ?>>
        <?php
        if (Permissions::can(Permissions::DOCTOR_ORDER_VIEW)) {
            ?>
            <a href="/shop/admin/orders/manage.orders.php">
                All
            </a>
            <?php
        } else {
            ?>
            <a href="/shop/admin/orders/manage.orders.php?start_date=<?= urlencode($start_date); ?>&end_date=<?= urlencode($end_date); ?>">
                All
            </a>
            <?php
        }
        ?>
    </li>
    <?php
    if (Permissions::can(Permissions::DOCTOR_ORDER_VIEW)) {
        $ordersHelper = new OrdersHelper([]);
        $pending_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_PENDING_REVIEW)
            ->get()
            ->count();
        $approved_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_APPROVED)
            ->get()
            ->count();
        $rejected_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_REJECTED)
            ->get()
            ->count();
        $waiting_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_AWAITING)
            ->get()
            ->count();
        $ready_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_READY)
            ->get()
            ->count();

        ?>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'pending_review') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=pending_review">
                Pending Review [<?= (int)$pending_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'approved') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=approved">
                Approved [<?= (int)$approved_count ?>]
            </a>
        </li>
        <?php if (Permissions::can(Permissions::PHARMACIST_ORDER_VIEW)) { ?>
            <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'ready') { ?> class="selected"<?php } ?>>
                <a href="/shop/admin/orders/manage.orders.php?order_type=ready">
                    Ready [<?= $ready_count ?>]
                </a>
            </li>
        <?php } ?>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'rejected') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=rejected">
                Rejected [<?= (int)$rejected_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'awaiting') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=awaiting">
                Waiting For Response [<?= (int)$waiting_count ?>]
            </a>
        </li>
        <?php

    } else {

        $ordersHelper = new OrdersHelper([]);
        $processing_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_PROCESSING)
            ->get()
            ->count();
        $refunded_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_REFUNDED)
            ->get()
            ->count();
        $cancelled_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_CANCELLED)
            ->get()
            ->count();
        $completed_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_COMPLETED)
            ->get()
            ->count();
        $returned_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_RETURNED)
            ->get()
            ->count();
        $no_response_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_NO_RESPONSE)
            ->get()
            ->count();
        $ready_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_READY)
            ->get()
            ->count();
        $approved_count = $ordersHelper->getOrdersBuilderQuery(OrdersHelper::ORDER_TYPE_APPROVED)
            ->get()
            ->count();

        ?>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'processing') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=processing">
                Processing [<?= (int)$processing_count ?>]
            </a>
        </li>
        <?php
        if (Permissions::can(Permissions::PHARMACIST_ORDER_VIEW)) {
            ?>
            <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'approved') { ?> class="selected"<?php } ?>>
                <a href="/shop/admin/orders/manage.orders.php?order_type=approved">
                    Approved [<?= $approved_count ?>]
                </a>
            </li>
            <?php
        }
        ?>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'ready') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=ready">
                Ready [<?= $ready_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'refunded') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=refunded">
                Refunded [<?= (int)$refunded_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'cancelled') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=cancelled">
                Cancelled [<?= (int)$cancelled_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'completed') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=completed&start_date=<?= urlencode($start_date); ?>&end_date=<?= urlencode($end_date); ?>">
                Completed [<?= (int)$completed_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'returned') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=returned&start_date=<?= urlencode($start_date); ?>&end_date=<?= urlencode($end_date); ?>">
                Returned [<?= (int)$returned_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'no_response') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=no_response&start_date=<?= urlencode($start_date); ?>&end_date=<?= urlencode($end_date); ?>">
                No Response [<?= (int)$no_response_count ?>]
            </a>
        </li>
        <li<?php if ($_SERVER['SCRIPT_NAME'] === '/shop/admin/orders/manage.orders.php' && $type === 'unpaid') { ?> class="selected"<?php } ?>>
            <a href="/shop/admin/orders/manage.orders.php?order_type=unpaid">
                Unpaid Orders
            </a>
        </li>

        <?php
    }

    Event::dispatch(OrderTabNavPrintedEvent::class, new OrderTabNavPrintedEvent());
    ?>
</ul>
