<?php

$browse_data = [];
$brand_data = [];
$category_data = [];

if (!isset($title)) {
    $title = '';
}

$root_segment = reset($filter->selections_all);
if ($root_segment) {
    switch ($root_segment['type']) {
        case 'brand':
            $brand_data = brand_data($filter->selections['brands'][0]);
            $browse_data = $brand_data;
            if ($browse_data['image']) {
                $browse_data['banner'] = '/' . $image_folders['brand_images']['normal']['path'] . '/' . $browse_data['image'];
            } elseif ( !empty($placeholder_images['brand']['value'])) {
                $browse_data['banner'] = '/' . $image_folders['brand_images']['normal']['path'] . '/' . $placeholder_images['brand']['value'];
            }
            break;

        case 'category':
            $category_data = category_data($filter->selections['categories_all'][count($filter->selections['categories_all']) - 1]);
            $browse_data = $category_data;
            if ($browse_data['image']) {
                $browse_data['banner'] = '/' . $image_folders['category_images']['normal']['path'] . '/' . $browse_data['image'];
            } elseif ( !empty($placeholder_images['category']['value'])) {
                $browse_data['banner'] = '/' . $image_folders['category_images']['normal']['path'] . '/' . $placeholder_images['category']['value'];
            }
            break;
    }
}


// title should be based on last brand & cat selected
if ($brand_data) {
    $title .= ' ' . $brand_data['name'];
}

if ($category_data) {
    $title .= ' ' . $category_data['name'];
}

$title = clean_page($title);

if (! $title) {
    $title = 'Shop';
}

// Override h1 title with seoadmin heading
// if exists
if (isset($seoadmin->data['heading']) && !empty($seoadmin->data['heading'])) {
    $browse_data['name'] = $seoadmin->data['heading'];
}

echo $twig->render('shop/browse/title.twig', [
    'browse_data' => $browse_data
]);
