<?php

namespace Mtc\Shop\Category;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\Shop\Category;
use Mtc\Cms\Models\AssetGalleryIcon;


class CategoriesDisplayTag extends Model
{
    protected $table = 'categories__display_tags';

    protected $fillable = [
        'group_name',
        'category_id',
        'label',
    ];


    public const DEFAULT_GROUP_NAME = 'a';


    public function icon()
    {
        return $this->belongsTo(AssetGalleryIcon::class, 'icon_id');
    }
}
