<?php
/**
 * Class EmailTemplate
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * Class EmailTemplate
 *
 * Model for managing email templates.
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class EmailTemplate extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'standard_template_letters';

    /**
     * @var string[] $fillable fillable attributes
     */
    protected $fillable = [
        'title',
        'template'
    ];

    /**
     * @var bool $timestamps this model does not have timestamps
     */
    public $timestamps = false;

}
