<!doctype html>
<html>
<head>

<?php
require_once $path . 'core/admin/templates/meta.php';

HooksAdapter::do_action('admin_header');
?>

</head>

<body data-admin="1">

    <div id="dialog" class="hidden"></div>

    <div id="wrapper">

        <div id="header">

            <a href="/admin/" title="mtc." class="logo">
                <?= file_get_contents(SITE_PATH . '/core/admin/images/logo.svg') ?>
            </a> <!-- .logo -->

            <ul class="headerTitleSection">
                <li>
                    <span><?= config('app.name') ?></span> Admin Dashboard
                </li>
            </ul>

            <?php
            if (!empty($_SESSION['adminId']) && isset($adminuser)) {
                ?>

                <ul class="headerMenuSections p">
                    <li>
                        Welcome back <span title="User ID: <?= $adminuser->user['id'] ?>"><?= clean_page($adminuser->user['name']) ?></span>
                    </li>

                    <?php if (!empty($new_message_count)) { ?>
                        <li>
                            <a href="/plugins/MembersMessaging/admin/my_messages.php" style="color: red;">
                                <i class="fa fa-exclamation-triangle"></i>
                                <strong>You have <?=$new_message_count;?> unread messages</strong>
                            </a>
                        </li>
                    <?php } ?>

                    <li>
                        <a href="/admin/" title="Go to <?= config('app.name') ?> Admin home">
                            <i class="fa fa-home"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="/" title="Go to <?= config('app.name') ?>" target="_blank">
                            <i class="fa fa-globe"></i>
                            Homepage
                        </a>
                    </li>

                    <li>
                        <a href="/admin/logout.php">
                            <i class="fa fa-sign-out"></i>
                            Logout
                        </a>
                    </li>
                </ul> <!-- .text -->
                <?php
            }
            ?>

            <a class="flyoutButton">
                Menu<i class="fa fa-bars" aria-hidden="true"></i>
            </a>

        </div> <!-- #head -->

        <div id="content">

        <?php
        require_once $path . "core/admin/templates/main.nav.php";
