<?php
/**
 * Admin Users Permission
 *
 * Manages Admin Users Permission.
 *
 * @author Florin Radica <florin.radica@mtcmedia.co.uk>
 * @since 04/07/2017
 */

namespace Mtc\Core;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class AdminUsersPermission
 */
class AdminUsersPermission extends Model
{
    /**
     * @var array $fillable Fillable columns
     */
    protected $fillable = [
        'user_id',
        'menu_id',
    ];

    /**
     * Gets the admin user for this permission
     *
     * @return BelongsTo The query builder instance
     */
    public function adminUser()
    {
        return $this->belongsTo(AdminUser::class, 'user_id');
    }

    /**
     * Gets the admin menu for this permission
     *
     * @return BelongsTo The query builder instance
     */
    public function adminMenu()
    {
        return $this->belongsTo(AdminMenu::class, 'menu_id');
    }
}
