<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_notes', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('member_id');
            $table->integer('admin_user_id')->nullable();
            $table->unsignedInteger('order_id')->nullable();
            $table->text('content')->nullable();
            $table->timestamps();

            $table->foreign('member_id')
                ->references('id')
                ->on('members')
                ->onDelete('cascade')
                ->onUpdate('cascade');

            $table->foreign('admin_user_id')
                ->references('id')
                ->on('admin_users')
                ->onDelete('set null')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_notes');
    }
};
