<?php

namespace Database\Seeders;

use Database\Factories\OrderAddressFactory;
use Database\Factories\OrderFactory;
use Database\Factories\OrderInfoFactory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Mtc\Modules\Members\Models\Member;
use Mtc\Shop\Order\Item;

class OrderTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        \DB::table('order')->delete();
        \DB::table('order_address')->delete();
        \DB::table('order_info')->delete();

        $members = Member::inRandomOrder()->get();

        foreach ($members as $member) {
            $order = OrderFactory::new()->create([
                'member' => $member->id, 
            ]);
            
            OrderAddressFactory::new()->billing()->create(['order_id' => $order->id]);
            OrderAddressFactory::new()->shipping()->create(['order_id' => $order->id]);
            
            OrderInfoFactory::new()
                ->cutomer_details($member)
                ->create(['order_id' => $order->id]);
        }
    }
}
