<?php
/**
 * Form Builder Installer.
 *
 * This code is used to Install Static blocks on site
 *
 * @category Plugins
 *
 * @author mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Illuminate\Database\Capsule\Manager as Capsule;

$schema = Capsule::connection()->getSchemaBuilder();

// Indicates if there is some tables missing
$missing_tables = false;

// Check if forms table exists. If it doesn't, build it
if ($schema->hasTable('forms') === false) {    // Builds the table
    $schema->create(
        'forms', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('published');
            $table->string('name');
            $table->integer('save_db');
            $table->integer('send_email');
            $table->string('email_receiver');
            $table->string('redirect');
            $table->integer('no_limit');
            $table->dateTime('display_until');
            $table->integer('type');
            $table->string('css_id');
            $table->string('css_class');
            $table->string('button_class');
            $table->string('submit_text');
            $table->integer('callback');
            $table->string('callback_class');
            $table->string('callback_action');
            $table->text('info_text');
            $table->text('success_text');
        }
    );
    $missing_tables = true;
}

// Check if form question table exists. If it doesn't, build it
if ($schema->hasTable('forms_questions') === false) {
    // Builds the table
    $schema->create(
        'forms_questions', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('form_id');
            $table->integer('fieldset_id');
            $table->string('name');
            $table->string('slug');
            $table->string('placeholder');
            $table->string('css_class');
            $table->string('type');
            $table->string('validate');
            $table->string('regex');
            $table->integer('required');
            $table->integer('freetext_answer');
            $table->integer('order');
        }
    );
    $missing_tables = true;
}

// Check if form fieldset table exists. If it doesn't, build it
if ($schema->hasTable('forms_fieldsets') === false) {
    // Builds the table
    $schema->create(
        'forms_fieldsets', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('form_id');
            $table->string('name');
            $table->string('css_class');
            $table->string('css_id');
            $table->tinyInteger('show_title');
            $table->string('placeholder');
            $table->integer('order');
        }
    );
    $missing_tables = true;
}

// Check if form question option table exists. If it doesn't, build it
if ($schema->hasTable('forms_questions_options') === false) {
    // Builds the table
    $schema->create(
        'forms_questions_options', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('question_id');
            $table->string('value');
            $table->integer('order');
    }
    );
    $missing_tables = true;
}

// Check if form responses table exists. If it doesn't, build it
if ($schema->hasTable('forms_responses') === false) {
    // Builds the table
    $schema->create(
        'forms_responses', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('form_id');
            $table->dateTime('date');
            $table->string('ip');
        }
    );
    $missing_tables = true;
}

// Check if form response answer table exists. If it doesn't, build it
if ($schema->hasTable('forms_responses_answers') === false) {
    // Builds the table
    $schema->create(
        'forms_responses_answers', function ($table) {
            $table->increments('id')->unsigned;
            $table->integer('response_id');
            $table->integer('question_id');
            $table->string('value');
            $table->integer('value_id');
        }
    );
    $missing_tables = true;
}

if ($missing_tables) {
    // Get the path to the admin folder without public_html / fork directory
    $path_to_admin_folder = str_replace(SITE_PATH, '', dirname(__DIR__)).'/admin/';

    // Create the admin menu item
    Capsule::table('admin_menu')->insert(
        [
            'sub_id' => 1,
            'title' => 'Form Builder',
            'path' => $path_to_admin_folder,
            'activePath' => $path_to_admin_folder,
            'constant' => 'FORM_BUILDER_ENABLED',
            'icon' => 'fa fa-list-ol',
            'new_window' => 0,
            'order' => 2,
        ]
    );

    $data = [
        [
            'key' => 'FORM_BUILDER_ENABLED',
            'type' => 'bool',
            'value' => 1,
            'module' => 'FORM_BUILDER',
            'description' => 'Turn on/off Form Builder',
            'created_at' => new DateTime(),
        ],
    ];
    MTC\Core\Setting::Insert($data);
}
