<?php

namespace Mtc\Modules\Members\Classes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Modules\Members\Models\Member;

/**
 * BelongsToMember Trait.
 * Use this on model that belong to member, will add:
 * * scope ofMember($member_id)
 * * member relationship
 *
 * @author Aleksey Lavrinenko
 */
trait BelongsToMember
{
    /**
     * Eloquent Scope ofMember($member)
     *
     * @param Builder $query
     * @param $member
     * @return $this
     */
    public function scopeOfMember(Builder $query, $member)
    {
        return $query->where("member_id", id($member));
    }

    /**
     * member() Eloquent relationship to Member class
     * @return BelongsTo
     */
    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id', 'id');
    }
}
